/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.Vector;
import net.logn.penrose.Dart;
import net.logn.penrose.DoubleKite;
import net.logn.penrose.FiveFold;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.Kite;
import net.logn.penrose.PenroseTiling;
import net.logn.penrose.PointGraph;

public abstract class Constellation {
    protected AffineTransform mapping;
    protected static final Shape empty = new Rectangle2D.Double();

    public abstract IntersectionPoint[] getKeyPair();

    public abstract IntersectionPoint[] getPattern();

    public abstract double getDelta();

    protected abstract Shape getTile();

    protected abstract Shape getRhomb();

    public Shape getShape() {
        if (PenroseTiling.tilesNotRhombs) {
            return this.getTile();
        }
        return this.getRhomb();
    }

    protected void drawPreview(Graphics2D graphics2D, GeneralPath generalPath) {
        GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
        generalPath2.transform(this.mapping);
        graphics2D.fill(generalPath2);
    }

    protected void drawPreview(Graphics2D graphics2D) {
        graphics2D.fill(this.getShape());
    }

    public abstract PointGraph scanForPairs(SortedSet var1);

    protected static PointGraph scanForPairs(SortedSet sortedSet, double d) {
        PointGraph pointGraph = new PointGraph();
        Object[] objectArray = sortedSet.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray.length - 1) {
            int n3 = n2 + 1;
            while (n3 < objectArray.length) {
                IntersectionPoint intersectionPoint = (IntersectionPoint)objectArray[n2];
                IntersectionPoint intersectionPoint2 = (IntersectionPoint)objectArray[n3];
                if (PenroseTiling.inRange(intersectionPoint.distance(intersectionPoint2), d)) {
                    pointGraph.add(intersectionPoint, intersectionPoint2);
                }
                ++n3;
            }
            ++n2;
        }
        return pointGraph;
    }

    public abstract Constellation testPair(SortedSet var1, FiveFold var2, IntersectionPoint[] var3);

    protected static AffineTransform testRequiredBars(SortedSet sortedSet, FiveFold fiveFold, IntersectionPoint[] intersectionPointArray, IntersectionPoint[] intersectionPointArray2, IntersectionPoint[] intersectionPointArray3) {
        AffineTransform affineTransform = Constellation.getTransform(intersectionPointArray2, intersectionPointArray);
        if (affineTransform == null) {
            return null;
        }
        int n = 0;
        while (n < intersectionPointArray3.length) {
            IntersectionPoint intersectionPoint = intersectionPointArray3[n];
            IntersectionPoint intersectionPoint2 = fiveFold.getIntersectionPoint(affineTransform.transform(intersectionPoint, null));
            if (intersectionPoint2 == null || !sortedSet.contains(intersectionPoint2)) {
                return null;
            }
            double d = intersectionPoint.seq2.rotation - intersectionPoint.seq1.rotation;
            double d2 = intersectionPoint2.seq2.rotation - intersectionPoint2.seq1.rotation;
            if (d != d2 && d + d2 != 360.0) {
                return null;
            }
            ++n;
        }
        return affineTransform;
    }

    public static Collection getAllConstellations(SortedSet sortedSet, FiveFold fiveFold, Collection collection, Graphics2D graphics2D) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(Kite.getConstellations(sortedSet, fiveFold, collection, graphics2D));
        hashSet.addAll(Dart.getConstellations(sortedSet, fiveFold, collection, graphics2D));
        hashSet.addAll(DoubleKite.getConstellations(sortedSet, fiveFold, collection, graphics2D));
        return hashSet;
    }

    protected static Collection getConstellations(SortedSet sortedSet, FiveFold fiveFold, Collection collection, Constellation constellation, Graphics2D graphics2D) {
        IntersectionPoint[] intersectionPointArray;
        IntersectionPoint[] intersectionPointArray2;
        double d = constellation.getDelta();
        IntersectionPoint[] intersectionPointArray3 = constellation.getKeyPair();
        IntersectionPoint[] intersectionPointArray4 = constellation.getPattern();
        Vector<Constellation> vector = new Vector<Constellation>();
        PointGraph pointGraph = new PointGraph();
        if (collection == null || collection.size() < 2) {
            pointGraph = Constellation.scanForPairs(sortedSet, d);
        } else {
            SortedSet<IntersectionPoint> sortedSet2;
            intersectionPointArray2 = collection.iterator();
            IntersectionPoint[] intersectionPointArray5 = (IntersectionPoint[])intersectionPointArray2.next();
            while (intersectionPointArray2.hasNext()) {
                intersectionPointArray = intersectionPointArray5;
                intersectionPointArray5 = (IntersectionPoint)intersectionPointArray2.next();
                sortedSet2 = sortedSet.subSet(intersectionPointArray, intersectionPointArray5);
                pointGraph.addAll(Constellation.scanForPairs(sortedSet2, d));
            }
            sortedSet2 = sortedSet.tailSet(intersectionPointArray5);
            pointGraph.addAll(Constellation.scanForPairs(sortedSet2, d));
        }
        if (graphics2D != null) {
            intersectionPointArray2 = pointGraph.getPrimaries();
            int n = 0;
            while (n < intersectionPointArray2.length) {
                intersectionPointArray = pointGraph.getSecondaries(intersectionPointArray2[n]);
                int n2 = 0;
                while (n2 < intersectionPointArray.length) {
                    IntersectionPoint[] intersectionPointArray6 = new IntersectionPoint[]{intersectionPointArray2[n], intersectionPointArray[n2]};
                    Constellation constellation2 = constellation.testPair(sortedSet, fiveFold, intersectionPointArray6);
                    if (constellation2 != null) {
                        constellation2.drawPreview(graphics2D);
                        vector.add(constellation2);
                    } else {
                        IntersectionPoint[] intersectionPointArray7 = new IntersectionPoint[]{intersectionPointArray6[1], intersectionPointArray6[0]};
                        constellation2 = constellation.testPair(sortedSet, fiveFold, intersectionPointArray7);
                        if (constellation2 != null) {
                            constellation2.drawPreview(graphics2D);
                            vector.add(constellation2);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            intersectionPointArray2 = pointGraph.getPrimaries();
            int n = 0;
            while (n < intersectionPointArray2.length) {
                intersectionPointArray = pointGraph.getSecondaries(intersectionPointArray2[n]);
                int n3 = 0;
                while (n3 < intersectionPointArray.length) {
                    IntersectionPoint[] intersectionPointArray8 = new IntersectionPoint[]{intersectionPointArray2[n], intersectionPointArray[n3]};
                    Constellation constellation3 = constellation.testPair(sortedSet, fiveFold, intersectionPointArray8);
                    if (constellation3 != null) {
                        vector.add(constellation3);
                    } else {
                        IntersectionPoint[] intersectionPointArray9 = new IntersectionPoint[]{intersectionPointArray8[1], intersectionPointArray8[0]};
                        constellation3 = constellation.testPair(sortedSet, fiveFold, intersectionPointArray9);
                        if (constellation3 != null) {
                            vector.add(constellation3);
                        }
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return vector;
    }

    public static AffineTransform getTransform(IntersectionPoint[] intersectionPointArray, IntersectionPoint[] intersectionPointArray2) {
        AffineTransform affineTransform = new AffineTransform();
        double d = intersectionPointArray2[0].getX() - intersectionPointArray[0].getX();
        double d2 = intersectionPointArray2[0].getY() - intersectionPointArray[0].getY();
        double d3 = intersectionPointArray[1].getX() - intersectionPointArray[0].getX();
        double d4 = intersectionPointArray[1].getY() - intersectionPointArray[0].getY();
        double d5 = intersectionPointArray2[1].getX() - intersectionPointArray2[0].getX();
        double d6 = intersectionPointArray2[1].getY() - intersectionPointArray2[0].getY();
        double d7 = PenroseTiling.atan2(d3, d4);
        double d8 = PenroseTiling.atan2(d5, d6);
        double d9 = d8 - d7;
        affineTransform.translate(intersectionPointArray2[0].getX(), intersectionPointArray2[0].getY());
        affineTransform.rotate(Math.toRadians(d9));
        affineTransform.translate(-intersectionPointArray[0].getX(), -intersectionPointArray[0].getY());
        return affineTransform;
    }

    public static IntersectionPoint mapOptional(IntersectionPoint intersectionPoint, AffineTransform affineTransform, FiveFold fiveFold, int n) {
        Point2D point2D = affineTransform.transform(intersectionPoint, null);
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        while (n2 < 5 && n3 == -1) {
            if (fiveFold.isForced(point2D, fiveFold.sequences[n2])) {
                n3 = n2;
            }
            ++n2;
        }
        while (n2 < 5 && n4 == -1) {
            if (fiveFold.isForced(point2D, fiveFold.sequences[n2])) {
                n4 = n2;
            }
            ++n2;
        }
        if (n3 != -1 && n4 != -1) {
            long l = FiveFold.getBarNum(fiveFold.sequences[n3], point2D);
            long l2 = FiveFold.getBarNum(fiveFold.sequences[n4], point2D);
            return new IntersectionPoint(fiveFold.sequences[n3], l, fiveFold.sequences[n4], l2, point2D);
        }
        if (n3 != -1) {
            int n5 = (n3 + n) % 5;
            IntersectionPoint intersectionPoint2 = new IntersectionPoint(point2D);
            intersectionPoint2.seq1 = fiveFold.sequences[n5];
            return intersectionPoint2;
        }
        System.err.println("Couldn't find required bar!!!");
        return null;
    }

    public abstract boolean forceBars(FiveFold var1);

    public abstract String toString();

    public static void main(String[] stringArray) {
        AffineTransform affineTransform = new AffineTransform();
        Point2D.Double double_ = new Point2D.Double(3.0, 3.0);
        Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
        double d = Math.toRadians(-45.0);
        affineTransform = new AffineTransform(Math.cos(d), -Math.sin(d), 0.0, Math.sin(d), Math.cos(d), 0.0);
        System.out.println(affineTransform);
        System.out.println(affineTransform.transform(double_, null));
        System.out.println(affineTransform.transform(double_2, null));
    }
}

