/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import net.logn.penrose.Constellation;
import net.logn.penrose.FiveFold;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.PenroseTiling;
import net.logn.penrose.PointGraph;

public class Dart
extends Constellation {
    protected static IntersectionPoint[] pattern;
    protected static IntersectionPoint[] keyPair;
    protected static double delta;
    protected static GeneralPath tile;
    protected static GeneralPath rhomb;
    protected static IntersectionPoint optionalLeft;
    protected static IntersectionPoint optionalRight;
    private IntersectionPoint left;
    private IntersectionPoint right;

    public Dart() {
        this(new AffineTransform());
    }

    public Dart(AffineTransform affineTransform) {
        this(affineTransform, null, null);
    }

    public Dart(AffineTransform affineTransform, IntersectionPoint intersectionPoint, IntersectionPoint intersectionPoint2) {
        this.mapping = affineTransform;
        this.left = intersectionPoint;
        this.right = intersectionPoint2;
    }

    public IntersectionPoint[] getKeyPair() {
        return keyPair;
    }

    public IntersectionPoint[] getPattern() {
        return pattern;
    }

    public double getDelta() {
        return delta;
    }

    protected Shape getTile() {
        GeneralPath generalPath = (GeneralPath)tile.clone();
        generalPath.transform(this.mapping);
        return generalPath;
    }

    protected Shape getRhomb() {
        GeneralPath generalPath = (GeneralPath)rhomb.clone();
        generalPath.transform(this.mapping);
        return generalPath;
    }

    public PointGraph scanForPairs(SortedSet sortedSet) {
        return Constellation.scanForPairs(sortedSet, delta);
    }

    public Constellation testPair(SortedSet sortedSet, FiveFold fiveFold, IntersectionPoint[] intersectionPointArray) {
        AffineTransform affineTransform = Constellation.testRequiredBars(sortedSet, fiveFold, intersectionPointArray, keyPair, pattern);
        if (affineTransform == null) {
            return null;
        }
        IntersectionPoint intersectionPoint = Constellation.mapOptional(optionalLeft, affineTransform, fiveFold, 4);
        IntersectionPoint intersectionPoint2 = Constellation.mapOptional(optionalRight, affineTransform, fiveFold, 1);
        if (intersectionPoint.seq2 != null || intersectionPoint2.seq2 != null) {
            return new Dart(affineTransform, intersectionPoint, intersectionPoint2);
        }
        return null;
    }

    public static Collection getConstellations(SortedSet sortedSet, FiveFold fiveFold, Collection collection, Graphics2D graphics2D) {
        return Constellation.getConstellations(sortedSet, fiveFold, collection, new Dart(), graphics2D);
    }

    public boolean forceBars(FiveFold fiveFold) {
        if (this.left.seq2 == null) {
            return FiveFold.forcePoint(this.left.seq1, this.left);
        }
        if (this.right.seq2 == null) {
            return FiveFold.forcePoint(this.right.seq1, this.right);
        }
        return false;
    }

    public String toString() {
        return "Dart with " + this.mapping;
    }

    public static void main(String[] stringArray) {
        FiveFold fiveFold = PenroseTiling.sunConfiguration();
        System.out.println(":::Template points");
        System.out.println(":::\t" + pattern[0] + "\n:::\t" + pattern[1] + "\n:::\t" + pattern[2]);
        SortedSet sortedSet = fiveFold.findIntersectionPoints(-0.7, -0.5, 0.01, 0.01);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            System.out.println(":::Sky " + iterator.next());
        }
        Collection collection = Dart.getConstellations(sortedSet, fiveFold, null, null);
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Dart dart = (Dart)iterator2.next();
            System.out.println(":::Found " + dart);
        }
    }

    static {
        keyPair = new IntersectionPoint[2];
        FiveFold fiveFold = PenroseTiling.aceConfiguration();
        pattern = new IntersectionPoint[3];
        Dart.pattern[0] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[2], 0L);
        Dart.pattern[1] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[3], 0L);
        Dart.pattern[2] = FiveFold.getIntersectionPoint(fiveFold.sequences[2], 0L, fiveFold.sequences[3], 0L);
        Dart.keyPair[0] = pattern[0];
        Dart.keyPair[1] = pattern[2];
        delta = keyPair[0].distance(keyPair[1]);
        optionalLeft = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[4], 0L);
        optionalRight = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[1], 0L);
        tile = new GeneralPath();
        tile.moveTo(0.0f, 0.0f);
        float f = (float)(PenroseTiling.cos(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y));
        float f2 = (float)(PenroseTiling.sin(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y));
        float f3 = f - (float)(PenroseTiling.cos(72.0) * 1.0);
        tile.lineTo(f, f2);
        tile.lineTo(f3, 0.0f);
        tile.lineTo(f, -f2);
        tile.closePath();
        rhomb = new GeneralPath();
        rhomb.moveTo(0.0f, 0.0f);
        float f4 = (float)(PenroseTiling.cos(36.0) * PenroseTiling.TAU);
        float f5 = (float)(PenroseTiling.sin(36.0) * PenroseTiling.TAU);
        rhomb.lineTo(f4, f5);
        rhomb.lineTo(2.0f * f4, 0.0f);
        rhomb.lineTo(f4, -f5);
        rhomb.closePath();
    }
}

