/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import net.logn.penrose.Constellation;
import net.logn.penrose.FiveFold;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.PenroseTiling;
import net.logn.penrose.PointGraph;

public class DoubleKite
extends Constellation {
    protected static IntersectionPoint[] pattern;
    protected static IntersectionPoint[] keyPair;
    protected static IntersectionPoint force;
    protected static double delta;
    protected static GeneralPath tile;
    protected static GeneralPath rhomb;

    public DoubleKite() {
        this(new AffineTransform());
    }

    public DoubleKite(AffineTransform affineTransform) {
        this.mapping = affineTransform;
    }

    public IntersectionPoint[] getKeyPair() {
        return keyPair;
    }

    public IntersectionPoint[] getPattern() {
        return pattern;
    }

    public double getDelta() {
        return delta;
    }

    protected Shape getTile() {
        return Constellation.empty;
    }

    protected Shape getRhomb() {
        GeneralPath generalPath = (GeneralPath)rhomb.clone();
        generalPath.transform(this.mapping);
        return generalPath;
    }

    protected void drawPreview(Graphics2D graphics2D) {
        if (PenroseTiling.tilesNotRhombs) {
            this.drawPreview(graphics2D, tile);
        } else {
            this.drawPreview(graphics2D, rhomb);
        }
    }

    public PointGraph scanForPairs(SortedSet sortedSet) {
        return Constellation.scanForPairs(sortedSet, delta);
    }

    public Constellation testPair(SortedSet sortedSet, FiveFold fiveFold, IntersectionPoint[] intersectionPointArray) {
        AffineTransform affineTransform = Constellation.testRequiredBars(sortedSet, fiveFold, intersectionPointArray, keyPair, pattern);
        if (affineTransform != null) {
            return new DoubleKite(affineTransform);
        }
        return null;
    }

    public static Collection getConstellations(SortedSet sortedSet, FiveFold fiveFold, Collection collection, Graphics2D graphics2D) {
        return Constellation.getConstellations(sortedSet, fiveFold, collection, new DoubleKite(), graphics2D);
    }

    public boolean forceBars(FiveFold fiveFold) {
        IntersectionPoint intersectionPoint = Constellation.mapOptional(force, this.mapping, fiveFold, 1);
        if (intersectionPoint.seq2 == null) {
            return FiveFold.forcePoint(intersectionPoint.seq1, intersectionPoint);
        }
        return false;
    }

    public String toString() {
        return "DoubleKite with " + this.mapping;
    }

    public static void main(String[] stringArray) {
        FiveFold fiveFold = PenroseTiling.sunConfiguration();
        System.out.println(":::Template points");
        System.out.println(":::\t" + pattern[0] + "\n:::\t" + pattern[1] + "\n:::\t" + pattern[2]);
        SortedSet sortedSet = fiveFold.findIntersectionPoints(-0.7, -0.5, 0.01, 0.01);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            System.out.println(":::Sky " + iterator.next());
        }
        Collection collection = DoubleKite.getConstellations(sortedSet, fiveFold, null, null);
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            DoubleKite doubleKite = (DoubleKite)iterator2.next();
            System.out.println(":::Found " + doubleKite);
        }
    }

    static {
        keyPair = new IntersectionPoint[2];
        FiveFold fiveFold = PenroseTiling.deuceConfiguration();
        pattern = new IntersectionPoint[5];
        DoubleKite.pattern[0] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[1], 0L);
        DoubleKite.pattern[1] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[2], 0L);
        DoubleKite.pattern[2] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[4], 0L);
        DoubleKite.pattern[3] = FiveFold.getIntersectionPoint(fiveFold.sequences[2], 0L, fiveFold.sequences[4], 0L);
        DoubleKite.pattern[4] = FiveFold.getIntersectionPoint(fiveFold.sequences[3], 0L, fiveFold.sequences[4], 0L);
        DoubleKite.keyPair[0] = pattern[1];
        DoubleKite.keyPair[1] = pattern[3];
        delta = keyPair[0].distance(keyPair[1]);
        fiveFold.sequences[2].force(-1L, false);
        force = FiveFold.getIntersectionPoint(fiveFold.sequences[2], -1L, fiveFold.sequences[1], 0L);
        float f = (float)(PenroseTiling.cos(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y));
        float f2 = (float)(-(PenroseTiling.sin(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y)));
        float f3 = (float)(PenroseTiling.cos(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y + 0.75 + 0.25));
        float f4 = (float)(-(PenroseTiling.sin(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y + 0.75 + 0.25)));
        double d = 2.0 * (PenroseTiling.cos(36.0) * PenroseTiling.TAU);
        tile = new GeneralPath();
        tile.moveTo(f, f2);
        tile.lineTo((float)d, 0.0f);
        tile.lineTo((float)(PenroseTiling.cos(288.0) * d), (float)(PenroseTiling.sin(288.0) * d));
        tile.closePath();
        rhomb = new GeneralPath();
        rhomb.moveTo(f, f2);
        rhomb.lineTo((float)d, 0.0f);
        rhomb.lineTo(f3, f4);
        rhomb.lineTo((float)(PenroseTiling.cos(288.0) * d), (float)(PenroseTiling.sin(288.0) * d));
        rhomb.closePath();
    }
}

