/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.MusicalSequence;
import net.logn.penrose.PenroseTiling;

public class FiveFold
implements Serializable {
    public static final int NUMSEQUENCES = 5;
    protected MusicalSequence[] sequences = new MusicalSequence[5];

    public FiveFold() {
        int n = 0;
        while (n < 5) {
            this.sequences[n] = new MusicalSequence(0.0, 0.0, n * 72);
            ++n;
        }
    }

    public MusicalSequence getSequence(double d) {
        int n = (int)Math.rint(d / 72.0);
        if (n < 5) {
            return this.sequences[n];
        }
        return null;
    }

    public MusicalSequence getSequence(Point2D point2D) {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 5) {
            if (this.isForced(point2D, this.sequences[n3])) {
                ++n2;
                n = n3;
            }
            ++n3;
        }
        if (n2 == 1) {
            return this.sequences[n];
        }
        if (n2 > 1) {
            System.err.println("Too many bars!");
        }
        return null;
    }

    public static boolean forcePoint(MusicalSequence musicalSequence, Point2D point2D) {
        Point2D point2D2 = FiveFold.findNearestPoint(point2D, musicalSequence);
        double d = FiveFold.getDistanceAlongSequence(point2D2, musicalSequence);
        return musicalSequence.forceAtDistance(d);
    }

    public static double originToPoint(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        return double_.distance(point2D);
    }

    public static double originToPoint(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        return FiveFold.originToPoint(double_);
    }

    public static double getDistanceAlongSequence(double d, double d2, MusicalSequence musicalSequence) {
        return FiveFold.getDistanceAlongSequence(new Point2D.Double(d, d2), musicalSequence);
    }

    public static double getDistanceAlongSequence(Point2D point2D, MusicalSequence musicalSequence) {
        Point2D.Double double_ = new Point2D.Double(musicalSequence.centerX, musicalSequence.centerY);
        double d = double_.distance(point2D);
        double d2 = PenroseTiling.atan2(point2D.getX() - musicalSequence.centerX, point2D.getY() - musicalSequence.centerY);
        if (PenroseTiling.inRange(d2, musicalSequence.rotation)) {
            return d;
        }
        return -d;
    }

    protected static Point2D translateAlongSequence(Point2D point2D, MusicalSequence musicalSequence, double d) {
        return FiveFold.translateAlongSequence(point2D.getX(), point2D.getY(), musicalSequence, d);
    }

    protected static Point2D translateAlongSequence(double d, double d2, MusicalSequence musicalSequence, double d3) {
        double d4 = musicalSequence.rotation;
        double d5 = d3 * PenroseTiling.cos(d4);
        double d6 = d3 * PenroseTiling.sin(d4);
        Point2D.Double double_ = new Point2D.Double(d + d5, d2 + d6);
        return double_;
    }

    protected static Point2D barNumToPoint(MusicalSequence musicalSequence, long l) {
        return FiveFold.distanceToPoint(musicalSequence, musicalSequence.barToDouble(l));
    }

    protected static Point2D distanceToPoint(MusicalSequence musicalSequence, double d) {
        double d2 = musicalSequence.rotation;
        double d3 = d * PenroseTiling.cos(d2);
        double d4 = d * PenroseTiling.sin(d2);
        return new Point2D.Double(d3 += musicalSequence.centerX, d4 += musicalSequence.centerY);
    }

    protected static long getBarNum(MusicalSequence musicalSequence, Point2D point2D) {
        Point2D point2D2 = FiveFold.findNearestPoint(point2D, musicalSequence);
        double d = FiveFold.getDistanceAlongSequence(point2D2, musicalSequence);
        long l = musicalSequence.doubleToBar(d);
        return l;
    }

    protected IntersectionPoint getIntersectionPoint(Point2D point2D) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        while (n < 5 && n2 == -1) {
            if (this.isForced(point2D, this.sequences[n])) {
                n2 = n;
            }
            ++n;
        }
        while (n < 5 && n3 == -1) {
            if (this.isForced(point2D, this.sequences[n])) {
                n3 = n;
            }
            ++n;
        }
        if (n2 != -1 && n3 != -1) {
            long l = FiveFold.getBarNum(this.sequences[n2], point2D);
            long l2 = FiveFold.getBarNum(this.sequences[n3], point2D);
            return new IntersectionPoint(this.sequences[n2], l, this.sequences[n3], l2, point2D);
        }
        return null;
    }

    public IntersectionPoint getIntersectionPoint(double d, long l, double d2, long l2) {
        MusicalSequence musicalSequence = this.getSequence(d);
        MusicalSequence musicalSequence2 = this.getSequence(d2);
        return FiveFold.getIntersectionPoint(musicalSequence, l, musicalSequence2, l2);
    }

    public static IntersectionPoint getIntersectionPoint(MusicalSequence musicalSequence, long l, MusicalSequence musicalSequence2, long l2) {
        Point2D point2D = FiveFold.barNumToPoint(musicalSequence, l);
        Point2D point2D2 = FiveFold.barNumToPoint(musicalSequence2, l2);
        Point2D point2D3 = FiveFold.getIntersection(point2D, musicalSequence.rotation + 90.0, point2D2, musicalSequence2.rotation + 90.0);
        return new IntersectionPoint(musicalSequence, l, musicalSequence2, l2, point2D3);
    }

    public static Point2D getIntersection(Point2D point2D, double d, Point2D point2D2, double d2) {
        if (d == d2) {
            return null;
        }
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        if (d == 90.0) {
            d3 = point2D.getX();
        } else {
            d5 = PenroseTiling.tan(d);
            d7 = point2D.getY() - d5 * point2D.getX();
        }
        if (d2 == 90.0) {
            d3 = point2D2.getX();
        } else {
            d6 = PenroseTiling.tan(d2);
            d8 = point2D2.getY() - d6 * point2D2.getX();
        }
        if (d != 90.0 && d2 != 90.0) {
            d3 = (d8 - d7) / (d5 - d6);
        }
        d4 = d != 90.0 ? d5 * d3 + d7 : d6 * d3 + d8;
        return new Point2D.Double(d3, d4);
    }

    public boolean isForced(Point2D point2D) {
        return this.isForced(point2D.getX(), point2D.getY());
    }

    public boolean isForced(double d, double d2) {
        int n = 0;
        while (n < 5) {
            if (this.isForced(d, d2, this.sequences[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isForced(Point2D point2D, MusicalSequence musicalSequence) {
        return this.isForced(point2D.getX(), point2D.getY(), musicalSequence);
    }

    public boolean isForced(double d, double d2, MusicalSequence musicalSequence) {
        long l;
        double d3;
        Point2D point2D = FiveFold.findNearestPoint(d, d2, musicalSequence);
        double d4 = FiveFold.getDistanceAlongSequence(point2D, musicalSequence);
        if (PenroseTiling.inRange(d4, d3 = musicalSequence.barToDouble(l = musicalSequence.doubleToBar(d4)))) {
            return musicalSequence.isForced(l);
        }
        return false;
    }

    protected static Point2D findNearestPoint(Point2D point2D, MusicalSequence musicalSequence) {
        return FiveFold.findNearestPoint(point2D.getX(), point2D.getY(), musicalSequence);
    }

    protected static Point2D findNearestPoint(double d, double d2, MusicalSequence musicalSequence) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        double d3 = musicalSequence.rotation + 90.0;
        Point2D.Double double_2 = new Point2D.Double(musicalSequence.centerX, musicalSequence.centerY);
        double d4 = musicalSequence.rotation;
        Point2D point2D = FiveFold.getIntersection(double_, d3, double_2, d4);
        return point2D;
    }

    protected boolean PointsWithinRange(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Point2D.distance(d, d2, d3, d4);
        return PenroseTiling.inRange(d5, d7, d6);
    }

    public static long[] getForcedBars(double d, double d2, double d3, double d4, MusicalSequence musicalSequence) {
        return FiveFold.getBars(d, d2, d3, d4, musicalSequence, true);
    }

    public static long[] getUnforcedBars(double d, double d2, double d3, double d4, MusicalSequence musicalSequence) {
        return FiveFold.getBars(d, d2, d3, d4, musicalSequence, false);
    }

    protected static long[] getBars(double d, double d2, double d3, double d4, MusicalSequence musicalSequence, boolean bl) {
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MAX_VALUE;
        double[] dArray = new double[]{FiveFold.getDistanceAlongSequence(FiveFold.findNearestPoint(d, d2, musicalSequence), musicalSequence), FiveFold.getDistanceAlongSequence(FiveFold.findNearestPoint(d3, d2, musicalSequence), musicalSequence), FiveFold.getDistanceAlongSequence(FiveFold.findNearestPoint(d, d4, musicalSequence), musicalSequence), FiveFold.getDistanceAlongSequence(FiveFold.findNearestPoint(d3, d4, musicalSequence), musicalSequence)};
        int n = 0;
        while (n < 4) {
            if (dArray[n] < d6) {
                d6 = dArray[n];
            }
            if (dArray[n] > d5) {
                d5 = dArray[n];
            }
            ++n;
        }
        long l = musicalSequence.doubleToBar(d6);
        long l2 = musicalSequence.doubleToBar(d5);
        if (bl) {
            return musicalSequence.getForcedBars(l, l2);
        }
        return musicalSequence.getUnforcedBars(l, l2);
    }

    public SortedSet findIntersectionPoints(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        TreeSet treeSet = new TreeSet();
        if (d < d3) {
            d8 = d;
            d7 = d3 - d;
        } else {
            d8 = d3;
            d7 = d - d3;
        }
        if (d2 < d4) {
            d6 = d2;
            d5 = d4 - d2;
        } else {
            d6 = d4;
            d5 = d2 - d4;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d8, d6, d7, d5);
        if (PenroseTiling.DEBUG > 1) {
            System.err.println("Checking from " + d8 + ", " + d6 + " at a width of " + d7 + " and height of " + d5);
            System.err.println("Intercept rect is: " + double_);
        }
        long[][] lArrayArray = new long[5][];
        int n = 0;
        while (n < 5) {
            lArrayArray[n] = FiveFold.getForcedBars(d, d2, d3, d4, this.sequences[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2 + 1;
            while (n3 < 5) {
                int n4 = 0;
                while (n4 < lArrayArray[n2].length) {
                    int n5 = 0;
                    while (n5 < lArrayArray[n3].length) {
                        IntersectionPoint intersectionPoint = FiveFold.getIntersectionPoint(this.sequences[n2], lArrayArray[n2][n4], this.sequences[n3], lArrayArray[n3][n5]);
                        if (double_.contains(((Point2D)intersectionPoint).getX(), ((Point2D)intersectionPoint).getY())) {
                            IntersectionPoint intersectionPoint2 = new IntersectionPoint(this.sequences[n2], lArrayArray[n2][n4], this.sequences[n3], lArrayArray[n3][n5], intersectionPoint);
                            intersectionPoint2.addTo(treeSet);
                        }
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return treeSet;
    }

    public Line2D[] getForcedLines(double d, double d2, double d3, double d4) {
        return this.getLines(d, d2, d3, d4, true);
    }

    public Line2D[] getUnforcedLines(double d, double d2, double d3, double d4) {
        return this.getLines(d, d2, d3, d4, false);
    }

    public Line2D[] getLines(double d, double d2, double d3, double d4, boolean bl) {
        long[][] lArrayArray = new long[5][];
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            lArrayArray[n2] = FiveFold.getBars(d, d2, d3, d4, this.sequences[n2], bl);
            n += lArrayArray[n2].length;
            ++n2;
        }
        Line2D[] line2DArray = new Line2D[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 5) {
            Line2D[] line2DArray2 = this.sequences[n4].getLines(lArrayArray[n4], d, d2, d3, d4);
            int n5 = 0;
            while (n5 < line2DArray2.length) {
                line2DArray[n3] = line2DArray2[n5];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return line2DArray;
    }

    public Line2D[] getAxes(double d, double d2, double d3, double d4) {
        Line2D[] line2DArray = new Line2D[5];
        int n = 0;
        while (n < line2DArray.length) {
            line2DArray[n] = this.sequences[n].getAxis(d, d2, d3, d4);
            ++n;
        }
        return line2DArray;
    }

    public String toString() {
        return "FiveFold toString() Not implemented";
    }

    public static void main(String[] stringArray) {
        FiveFold fiveFold = new FiveFold();
        fiveFold.test();
        System.exit(0);
    }

    public void test() {
        Object object;
        System.out.println("\nTesting...");
        this.sequences[0].force(1L, false);
        this.sequences[1].force(1L, false);
        this.sequences[2].force(1L, false);
        this.sequences[3].force(1L, false);
        this.sequences[4].force(1L, false);
        System.out.println("\nNow checking intersection between two sequences, first bar of each, both with short interval");
        int n = 0;
        while (n < 5) {
            object = FiveFold.getIntersectionPoint(this.sequences[n], 1L, this.sequences[(n + 1) % 5], 1L);
            System.out.println("IntersectionPoint between " + this.sequences[n].rotation + "," + this.sequences[(n + 1) % 5].rotation + " at " + object.toString());
            ++n;
        }
        System.out.println("\nNow finding all intersetctions 1.2 away from origin...");
        object = this.findIntersectionPoints(-1.2, -1.2, 1.2, 1.2);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IntersectionPoint intersectionPoint = (IntersectionPoint)iterator.next();
            System.out.println(intersectionPoint.toString());
        }
        System.out.println("\n");
    }
}

