/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.logn.penrose.PenroseApplet;
import net.logn.penrose.PenrosePanel;
import net.logn.penrose.PenroseTiling;

public class ForceBarFrame
extends JFrame {
    protected PenroseTiling pt;
    protected PenrosePanel pp;
    protected int sequence;
    protected boolean length = true;
    protected long barNum = 0L;
    private JTextField barText;

    public ForceBarFrame(PenroseApplet penroseApplet) {
        this(PenroseApplet.penroseTiling, PenroseApplet.pPanel);
    }

    public ForceBarFrame(PenroseTiling penroseTiling, PenrosePanel penrosePanel) {
        super("Force New Bars");
        ((Component)this).setSize(new Dimension(400, 150));
        this.pt = penroseTiling;
        this.pp = penrosePanel;
        JLabel jLabel = new JLabel("Rotation:");
        JRadioButton jRadioButton = new JRadioButton("0");
        jRadioButton.setMnemonic(49);
        jRadioButton.setActionCommand("0");
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton("72");
        jRadioButton2.setMnemonic(50);
        jRadioButton2.setActionCommand("1");
        JRadioButton jRadioButton3 = new JRadioButton("144");
        jRadioButton3.setMnemonic(51);
        jRadioButton3.setActionCommand("2");
        JRadioButton jRadioButton4 = new JRadioButton("216");
        jRadioButton4.setMnemonic(52);
        jRadioButton4.setActionCommand("3");
        JRadioButton jRadioButton5 = new JRadioButton("288");
        jRadioButton5.setMnemonic(53);
        jRadioButton5.setActionCommand("4");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        SequenceListener sequenceListener = new SequenceListener();
        jRadioButton.addActionListener(sequenceListener);
        jRadioButton2.addActionListener(sequenceListener);
        jRadioButton3.addActionListener(sequenceListener);
        jRadioButton4.addActionListener(sequenceListener);
        jRadioButton5.addActionListener(sequenceListener);
        JRadioButton jRadioButton6 = new JRadioButton("Long");
        jRadioButton6.setMnemonic(76);
        jRadioButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForceBarFrame.this.length = true;
            }
        });
        jRadioButton6.setSelected(true);
        JRadioButton jRadioButton7 = new JRadioButton("Short");
        jRadioButton7.setMnemonic(83);
        jRadioButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForceBarFrame.this.length = false;
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton6);
        buttonGroup2.add(jRadioButton7);
        this.barText = new JTextField(10);
        JLabel jLabel2 = new JLabel("Bar Number:");
        JButton jButton = new JButton("Preview");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ForceBarFrame.this.getBarNum()) {
                    double[] dArray = ForceBarFrame.this.pt.getBoundingBox();
                    Line2D line2D = ForceBarFrame.this.pt.fiveFold.sequences[ForceBarFrame.this.sequence].getLine(ForceBarFrame.this.barNum, dArray[0], dArray[1], dArray[2], dArray[3]);
                    ForceBarFrame.this.pp.paintShape(line2D, Color.red, false);
                }
            }
        });
        JButton jButton2 = new JButton("Force");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ForceBarFrame.this.getBarNum()) {
                    ForceBarFrame.this.pt.fiveFold.sequences[ForceBarFrame.this.sequence].force(ForceBarFrame.this.barNum, ForceBarFrame.this.length);
                    double[] dArray = ForceBarFrame.this.pt.getBoundingBox();
                    ForceBarFrame.this.pt.forcedBars = ForceBarFrame.this.pt.fiveFold.getForcedLines(dArray[0], dArray[1], dArray[2], dArray[3]);
                    ForceBarFrame.this.pp.redraw();
                }
            }
        });
        JButton jButton3 = new JButton("Done");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForceBarFrame.this.hide();
                ForceBarFrame.this.dispose();
            }
        });
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        container.add(jRadioButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jRadioButton2, gridBagConstraints);
        container.add(jRadioButton2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jRadioButton3, gridBagConstraints);
        container.add(jRadioButton3);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jRadioButton4, gridBagConstraints);
        container.add(jRadioButton4);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jRadioButton5, gridBagConstraints);
        container.add(jRadioButton5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        container.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.barText, gridBagConstraints);
        container.add(this.barText);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jRadioButton6, gridBagConstraints);
        container.add(jRadioButton6);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jRadioButton7, gridBagConstraints);
        container.add(jRadioButton7);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        container.add(jButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        container.add(jButton2);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        container.add(jButton3);
    }

    protected boolean getBarNum() {
        try {
            this.barNum = Long.parseLong(this.barText.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.barNum = 0L;
            this.barText.setText("");
            return false;
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Penrose Applet With Extensions");
        PenroseApplet penroseApplet = new PenroseApplet(new Properties());
        jFrame.getContentPane().add("Center", penroseApplet);
        penroseApplet.init();
        jFrame.pack();
        ((Component)jFrame).setSize(new Dimension(600, 600));
        jFrame.show();
        ForceBarFrame forceBarFrame = new ForceBarFrame(penroseApplet);
        forceBarFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        forceBarFrame.show();
    }

    class SequenceListener
    implements ActionListener {
        SequenceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ForceBarFrame.this.sequence = Integer.parseInt(actionEvent.getActionCommand());
        }
    }
}

