/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import net.logn.penrose.MusicalSequence;
import net.logn.penrose.PenroseTiling;

public class IntersectionPoint
extends Point2D.Double
implements Comparable {
    protected MusicalSequence seq1;
    protected long bar1;
    protected MusicalSequence seq2;
    protected long bar2;
    protected double boxLayer;
    protected double boxTheta;
    private IntersectionPoint duplicateRight = null;
    private IntersectionPoint duplicateBottom = null;
    private IntersectionPoint duplicateDiagonal = null;

    public IntersectionPoint(Point2D point2D) {
        this.x = point2D.getX();
        this.y = point2D.getY();
        this.seq1 = null;
        this.bar1 = 0L;
        this.seq2 = null;
        this.bar2 = 0L;
        this.boxLayer = -1.0;
        this.boxTheta = -1.0;
    }

    public IntersectionPoint(MusicalSequence musicalSequence, long l, MusicalSequence musicalSequence2, long l2, Point2D point2D) {
        this(musicalSequence, l, musicalSequence2, l2, point2D.getX(), point2D.getY());
    }

    public IntersectionPoint(MusicalSequence musicalSequence, long l, MusicalSequence musicalSequence2, long l2, double d, double d2) {
        if (musicalSequence.rotation < musicalSequence2.rotation) {
            this.seq1 = musicalSequence;
            this.seq2 = musicalSequence2;
            this.bar1 = l;
            this.bar2 = l2;
        } else {
            this.seq2 = musicalSequence;
            this.seq1 = musicalSequence2;
            this.bar2 = l;
            this.bar1 = l2;
        }
        this.x = d;
        this.y = d2;
        this.computeBoxValues();
    }

    private IntersectionPoint(IntersectionPoint intersectionPoint, double d, double d2) {
        this.seq1 = intersectionPoint.seq1;
        this.seq2 = intersectionPoint.seq2;
        this.bar1 = intersectionPoint.bar1;
        this.bar2 = intersectionPoint.bar2;
        this.x = intersectionPoint.x;
        this.y = intersectionPoint.y;
        this.boxLayer = d;
        this.boxTheta = d2;
    }

    protected void computeBoxValues() {
        double[] dArray;
        double d = (this.x - -5.0) / 10.0;
        double d2 = (this.y - -5.0) / 10.0;
        double d3 = Math.floor(d);
        double d4 = Math.floor(d2);
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = d5 * 10.0 + 2.126627021;
        double d8 = d6 * 10.0 + 2.126627021;
        if (d7 > 10.0 && d8 > 10.0) {
            if (PenroseTiling.DEBUG > 5) {
                System.err.println("We've overflowed in both X and Y; duplicating point");
            }
            dArray = IntersectionPoint.getBoxInfo(d3 + 1.0, d4 + 1.0);
            this.duplicateDiagonal = new IntersectionPoint(this, dArray[0], dArray[1]);
        }
        if (d7 > 10.0) {
            if (PenroseTiling.DEBUG > 5) {
                System.err.println("We've overflowed in X; duplicating point");
            }
            dArray = IntersectionPoint.getBoxInfo(d3 + 1.0, d4);
            this.duplicateRight = new IntersectionPoint(this, dArray[0], dArray[1]);
        }
        if (d8 > 10.0) {
            if (PenroseTiling.DEBUG > 5) {
                System.err.println("We've overflowed in Y; duplicating point");
            }
            dArray = IntersectionPoint.getBoxInfo(d3, d4 + 1.0);
            this.duplicateBottom = new IntersectionPoint(this, dArray[0], dArray[1]);
        }
        if (PenroseTiling.DEBUG > 3) {
            System.err.println("Boxes between origin and point: " + d + ", " + d2);
            System.err.println("Overflow: " + d7 + ", " + d8);
            System.err.println("Actual Boxes: " + d3 + ", " + d4);
        }
        dArray = IntersectionPoint.getBoxInfo(d3, d4);
        this.boxLayer = dArray[0];
        this.boxTheta = dArray[1];
    }

    public Rectangle2D getBoxRect() {
        double d = (this.x - -5.0) / 10.0;
        double d2 = (this.y - -5.0) / 10.0;
        double d3 = Math.floor(d);
        double d4 = Math.floor(d2);
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = d5 * 10.0 + 2.126627021;
        double d8 = d6 * 10.0 + 2.126627021;
        if (d7 > 10.0) {
            return null;
        }
        if (d8 > 10.0) {
            return null;
        }
        return new Rectangle2D.Double(d3 * 10.0 + -5.0 - 2.126627021, d4 * 10.0 + -5.0 - 2.126627021, 12.126627021000001, 12.126627021000001);
    }

    protected static double[] getBoxInfo(double d, double d2) {
        double[] dArray = new double[]{Math.max(Math.abs(d), Math.abs(d2)), PenroseTiling.atan2(d, d2)};
        if (dArray[1] < 0.0) {
            dArray[1] = dArray[1] + 360.0;
        }
        if (PenroseTiling.DEBUG > 3) {
            System.err.println("I think that coordinates " + d + ", " + d2 + " form an angle of " + dArray[1] + " degrees");
        }
        return dArray;
    }

    public int compareTo(Object object) {
        IntersectionPoint intersectionPoint = (IntersectionPoint)object;
        if (this.boxLayer < intersectionPoint.boxLayer) {
            return -1;
        }
        if (intersectionPoint.boxLayer < this.boxLayer) {
            return 1;
        }
        if (this.boxTheta < intersectionPoint.boxTheta) {
            return -1;
        }
        if (intersectionPoint.boxTheta < this.boxTheta) {
            return 1;
        }
        if (this.seq1.rotation < intersectionPoint.seq1.rotation) {
            return -1;
        }
        if (intersectionPoint.seq1.rotation < this.seq1.rotation) {
            return 1;
        }
        if (this.seq2.rotation < intersectionPoint.seq2.rotation) {
            return -1;
        }
        if (intersectionPoint.seq2.rotation < this.seq2.rotation) {
            return 1;
        }
        if (this.bar1 < intersectionPoint.bar1) {
            return -1;
        }
        if (intersectionPoint.bar1 < this.bar1) {
            return 1;
        }
        if (this.bar2 < intersectionPoint.bar2) {
            return -1;
        }
        if (this.bar2 > intersectionPoint.bar2) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        IntersectionPoint intersectionPoint = (IntersectionPoint)object;
        if (this.seq1.rotation != intersectionPoint.seq1.rotation) {
            return false;
        }
        if (this.seq2.rotation != intersectionPoint.seq2.rotation) {
            return false;
        }
        if (this.bar1 != intersectionPoint.bar1) {
            return false;
        }
        return this.bar2 == intersectionPoint.bar2;
    }

    public boolean addTo(Collection collection) {
        boolean bl = false;
        bl = collection.add(this);
        if (this.duplicateRight != null) {
            boolean bl2 = bl = bl && collection.add(this.duplicateRight);
        }
        if (this.duplicateBottom != null) {
            boolean bl3 = bl = bl && collection.add(this.duplicateBottom);
        }
        if (this.duplicateDiagonal != null) {
            bl = bl && collection.add(this.duplicateDiagonal);
        }
        return bl;
    }

    public Ellipse2D getShape() {
        return new Ellipse2D.Double(this.x - 0.1, this.y - 0.1, 0.2, 0.2);
    }

    public static void main(String[] stringArray) {
        IntersectionPoint intersectionPoint;
        int n;
        System.out.println("\nRunning automatic tests\n\n");
        Vector vector = new Vector(25);
        MusicalSequence musicalSequence = new MusicalSequence(0.0, 0.0, 0.0);
        MusicalSequence musicalSequence2 = new MusicalSequence(0.0, 0.0, 72.0);
        musicalSequence.force(10L, true);
        musicalSequence2.force(10L, false);
        int n2 = 0;
        while (n2 < 100) {
            n = 0;
            while (n < 100) {
                intersectionPoint = new IntersectionPoint(musicalSequence, n2, musicalSequence2, n, n2, n);
                if (!intersectionPoint.addTo(vector)) {
                    System.out.println("Error Adding in addTo()!!!");
                }
                n += 10;
            }
            n2 += 10;
        }
        Collections.sort(vector);
        n = 0;
        while (n < vector.size()) {
            intersectionPoint = (IntersectionPoint)vector.elementAt(n);
            System.out.println("Point Box Layer: " + intersectionPoint.boxLayer + "  Theta: " + intersectionPoint.boxTheta);
            ++n;
        }
    }
}

