/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import net.logn.penrose.Constellation;
import net.logn.penrose.FiveFold;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.PenroseTiling;
import net.logn.penrose.PointGraph;

public class Kite
extends Constellation {
    protected static IntersectionPoint[] pattern;
    protected static IntersectionPoint[] keyPair;
    protected static double delta;
    protected static GeneralPath tile;
    protected static GeneralPath rhomb;

    public Kite() {
        this(new AffineTransform());
    }

    public Kite(AffineTransform affineTransform) {
        this.mapping = affineTransform;
    }

    public IntersectionPoint[] getKeyPair() {
        return keyPair;
    }

    public IntersectionPoint[] getPattern() {
        return pattern;
    }

    public double getDelta() {
        return delta;
    }

    protected Shape getTile() {
        GeneralPath generalPath = (GeneralPath)tile.clone();
        generalPath.transform(this.mapping);
        return generalPath;
    }

    protected Shape getRhomb() {
        return Constellation.empty;
    }

    protected void drawPreview(Graphics2D graphics2D) {
        if (PenroseTiling.tilesNotRhombs) {
            this.drawPreview(graphics2D, tile);
        } else {
            this.drawPreview(graphics2D, rhomb);
        }
    }

    public PointGraph scanForPairs(SortedSet sortedSet) {
        return Constellation.scanForPairs(sortedSet, delta);
    }

    public Constellation testPair(SortedSet sortedSet, FiveFold fiveFold, IntersectionPoint[] intersectionPointArray) {
        AffineTransform affineTransform = Constellation.testRequiredBars(sortedSet, fiveFold, intersectionPointArray, keyPair, pattern);
        if (affineTransform != null) {
            return new Kite(affineTransform);
        }
        return null;
    }

    public static Collection getConstellations(SortedSet sortedSet, FiveFold fiveFold, Collection collection, Graphics2D graphics2D) {
        return Constellation.getConstellations(sortedSet, fiveFold, collection, new Kite(), graphics2D);
    }

    public boolean forceBars(FiveFold fiveFold) {
        return false;
    }

    public String toString() {
        return "Kite with " + this.mapping;
    }

    public static void main(String[] stringArray) {
        FiveFold fiveFold = PenroseTiling.sunConfiguration();
        System.out.println(":::Template points");
        System.out.println(":::\t" + pattern[0] + "\n:::\t" + pattern[1] + "\n:::\t" + pattern[2]);
        SortedSet sortedSet = fiveFold.findIntersectionPoints(-0.7, -0.5, 0.01, 0.01);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            System.out.println(":::Sky " + iterator.next());
        }
        Collection collection = Kite.getConstellations(sortedSet, fiveFold, null, null);
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Kite kite = (Kite)iterator2.next();
            System.out.println(":::Found " + kite);
        }
    }

    static {
        keyPair = new IntersectionPoint[2];
        FiveFold fiveFold = PenroseTiling.sunConfiguration();
        pattern = new IntersectionPoint[3];
        Kite.pattern[0] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[1], 0L);
        Kite.pattern[1] = FiveFold.getIntersectionPoint(fiveFold.sequences[0], 0L, fiveFold.sequences[4], 0L);
        Kite.pattern[2] = FiveFold.getIntersectionPoint(fiveFold.sequences[1], 0L, fiveFold.sequences[4], 0L);
        Kite.keyPair[0] = pattern[0];
        Kite.keyPair[1] = pattern[1];
        delta = keyPair[0].distance(keyPair[1]);
        tile = new GeneralPath();
        tile.moveTo(0.0f, 0.0f);
        float f = (float)(PenroseTiling.cos(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y));
        float f2 = (float)(PenroseTiling.sin(36.0) * (PenroseTiling.MINNICK_X + PenroseTiling.MINNICK_Y));
        float f3 = (float)(0.25 + PenroseTiling.MINNICK_E);
        tile.lineTo(f, f2);
        tile.lineTo(f3, 0.0f);
        tile.lineTo(f, -f2);
        tile.closePath();
        rhomb = new GeneralPath();
        rhomb.moveTo(0.0f, 0.0f);
        rhomb.lineTo(f, f2);
        rhomb.lineTo(f3, 0.0f);
        rhomb.closePath();
    }
}

