/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import net.logn.penrose.FiveFold;
import net.logn.penrose.PenroseTiling;

public class MusicalSequence
implements Serializable {
    protected long upperX = 0L;
    protected long upperY = 1L;
    protected long lowerX = 0L;
    protected long lowerY = 0L;
    protected double centerX = 0.0;
    protected double centerY = 0.0;
    protected double rotation = 0.0;

    public MusicalSequence() {
    }

    public MusicalSequence(double d, double d2, double d3) {
        this();
        this.centerX = d;
        this.centerY = d2;
        this.rotation = d3;
    }

    public void setZeroBar(double d) {
        this.centerX = d * PenroseTiling.cos(this.rotation);
        this.centerY = d * PenroseTiling.sin(this.rotation);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.centerX, this.centerY);
    }

    public double getRotation() {
        return this.rotation;
    }

    public long getUpperX() {
        return this.upperX;
    }

    public long getUpperY() {
        return this.upperY;
    }

    public long getLowerX() {
        return this.lowerX;
    }

    public long getLowerY() {
        return this.lowerY;
    }

    protected static long truncateClosed(double d) {
        long l = (long)Math.floor(d);
        if ((double)l == d) {
            return l - 1L;
        }
        return l;
    }

    protected static long truncateOpen(double d) {
        return (long)Math.floor(d);
    }

    protected double findUpperIntercept() {
        return (double)this.upperY - (double)this.upperX * PenroseTiling.TAU;
    }

    protected double findLowerIntercept() {
        return (double)this.lowerY - (double)this.lowerX * PenroseTiling.TAU;
    }

    public double Interval(String string, String string2, String string3) {
        return this.findUpperIntercept() - this.findLowerIntercept();
    }

    protected double findPoint(long l, boolean bl) {
        double d = bl ? this.findUpperIntercept() : this.findLowerIntercept();
        return (double)l * PenroseTiling.TAU + d;
    }

    protected long findUpperPoint(long l) {
        return MusicalSequence.truncateClosed(this.findPoint(l, true));
    }

    protected long findLowerPoint(long l) {
        return MusicalSequence.truncateOpen(this.findPoint(l, false));
    }

    public void force(long l, boolean bl) {
        long l2;
        long l3 = this.findUpperPoint(l);
        if (l3 != (l2 = this.findLowerPoint(l))) {
            if (bl && l >= 0L || !bl && l < 0L) {
                this.lowerX = l;
                this.lowerY = l3;
            } else {
                this.upperX = l;
                this.upperY = l3;
            }
        }
    }

    public boolean isForced(long l) {
        long l2;
        long l3 = this.findUpperPoint(l);
        return l3 == (l2 = this.findLowerPoint(l));
    }

    public String distanceTo(long l) {
        long l2 = this.findUpperPoint(l);
        long l3 = 2L * l - l2;
        long l4 = l2 - l;
        return l3 + "s + " + l4 + "l";
    }

    public double offsetDistance(String string) {
        return 0.0;
    }

    public double barToDouble(long l) {
        long l2 = this.findUpperPoint(l);
        long l3 = 2L * l - l2;
        long l4 = l2 - l;
        return PenroseTiling.SCALE * (double)l3 + PenroseTiling.SCALE * PenroseTiling.TAU * (double)l4;
    }

    public long doubleToBar(double d) {
        double d2 = d / (PenroseTiling.SHORT + PenroseTiling.TAU * PenroseTiling.LONG);
        double d3 = d2 * PenroseTiling.TAU;
        return Math.round(d2 + d3);
    }

    private double ddist(long l, long l2, double d) {
        double d2 = (double)l + PenroseTiling.TAU * (double)l2;
        double d3 = Math.abs(d - d2);
        return d3;
    }

    public boolean forceAtDistance(double d) {
        double d2 = d / PenroseTiling.SCALE;
        double d3 = d2 / (2.0 + PenroseTiling.TAU);
        double d4 = d3 * PenroseTiling.TAU;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        lArray[0] = (long)Math.floor(d3);
        lArray[1] = lArray[0] + 1L;
        lArray2[0] = (long)Math.floor(d4);
        lArray2[1] = lArray2[0] + 1L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 2) {
                if (this.ddist(lArray[n3], lArray2[n4], d2) <= this.ddist(lArray[n], lArray2[n2], d2)) {
                    n = n3;
                    n2 = n4;
                }
                ++n4;
            }
            ++n3;
        }
        long l = lArray[n] + lArray2[n2];
        boolean bl = false;
        if (n2 == 0 && l > -1L) {
            bl = this.isForced(l);
            this.force(l, false);
        } else if (n2 == 1 && l > -1L) {
            bl = this.isForced(l);
            this.force(l, true);
        } else if (n2 == 0 && l < 0L) {
            bl = this.isForced(l);
            this.force(l, true);
        } else {
            bl = this.isForced(l);
            this.force(l, false);
        }
        return !bl;
    }

    public long[] getUnforcedBars(long l, long l2) {
        long[] lArray = new long[(int)(l2 - l + 1L)];
        int n = 0;
        long l3 = l;
        while (l3 <= l2) {
            if (!this.isForced(l3)) {
                lArray[n] = l3;
                ++n;
            }
            ++l3;
        }
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = lArray[n2];
            ++n2;
        }
        return lArray2;
    }

    public Line2D[] getUnforcedLines(long l, long l2) {
        long[] lArray = this.getUnforcedBars(l, l2);
        return this.getLines(lArray);
    }

    public long[] getForcedBars(long l, long l2) {
        long[] lArray = new long[(int)(l2 - l + 1L)];
        int n = 0;
        long l3 = l;
        while (l3 <= l2) {
            if (this.isForced(l3)) {
                lArray[n] = l3;
                ++n;
            }
            ++l3;
        }
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = lArray[n2];
            ++n2;
        }
        return lArray2;
    }

    public Line2D[] getForcedLines(long l, long l2) {
        long[] lArray = this.getForcedBars(l, l2);
        return this.getLines(lArray);
    }

    public Line2D[] getLines(long[] lArray) {
        Line2D[] line2DArray = new Line2D[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            line2DArray[n] = this.getLine(lArray[n]);
            ++n;
        }
        return line2DArray;
    }

    public Line2D[] getLines(long[] lArray, double d, double d2, double d3, double d4) {
        Line2D[] line2DArray = new Line2D[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            line2DArray[n] = this.getLine(lArray[n], d, d2, d3, d4);
            ++n;
        }
        return line2DArray;
    }

    public Line2D getLine(long l) {
        return this.getLine(l, -10000.0, -10000.0, 10000.0, 10000.0);
    }

    public Line2D getLine(long l, double d, double d2, double d3, double d4) {
        Point2D point2D = FiveFold.barNumToPoint(this, l);
        double d5 = this.rotation + 90.0;
        return MusicalSequence.getLineSegment(point2D, d5, d, d2, d3, d4);
    }

    public Line2D getAxis(double d, double d2, double d3, double d4) {
        Point2D.Double double_ = new Point2D.Double(this.centerX, this.centerY);
        return MusicalSequence.getLineSegment(double_, this.rotation, d, d2, d3, d4);
    }

    public static Line2D getLineSegment(Point2D point2D, double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        if (d2 < d4) {
            d9 = d2;
            d8 = d4;
        } else {
            d9 = d4;
            d8 = d2;
        }
        if (d3 < d5) {
            d7 = d5;
            d6 = d3;
        } else {
            d7 = d3;
            d6 = d5;
        }
        double d10 = PenroseTiling.cos(d);
        double d11 = PenroseTiling.sin(d);
        double d12 = (d9 - point2D.getX()) / d10 * d11 + point2D.getY();
        double d13 = (d7 - point2D.getY()) / d11 * d10 + point2D.getX();
        double d14 = (d8 - point2D.getX()) / d10 * d11 + point2D.getY();
        double d15 = (d6 - point2D.getY()) / d11 * d10 + point2D.getX();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int n = 0;
        if (d12 < d7 && d12 > d6) {
            dArray[n] = d9;
            dArray2[n] = d12;
            ++n;
        }
        if (d13 < d8 && d13 > d9) {
            dArray[n] = d13;
            dArray2[n] = d7;
            ++n;
        }
        if (d14 < d7 && d14 > d6) {
            dArray[n] = d8;
            dArray2[n] = d14;
            ++n;
        }
        if (d15 < d8 && d15 > d9) {
            dArray[n] = d15;
            dArray2[n] = d6;
            ++n;
        }
        if (n == 2) {
            return new Line2D.Double(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        }
        return new Line2D.Double();
    }

    public String toString() {
        return this.toString(0L, 10L);
    }

    public String toString(long l, long l2) {
        String string = "\n| ";
        long l3 = 0L;
        long l4 = 1L;
        while (l4 <= l2) {
            long l5 = this.findLowerPoint(l + l4);
            string = l5 - l3 == 1L ? string + "S " : string + "L ";
            l3 = l5;
            if (this.isForced(l + l4)) {
                string = string + "| ";
            }
            ++l4;
        }
        string = string + "\n\nUpper Bound:\t" + this.findUpperIntercept() + "\nLower Bound:\t" + this.findLowerIntercept() + "\n";
        string = string + "\n\nUpper Bar " + this.upperX + " has y value " + this.upperY + "\n\nLower Bar " + this.lowerX + " has y value " + this.lowerY;
        string = string + "\n\nCenter at:\t(" + this.centerX + " , " + this.centerY + ")\tRotation: " + this.rotation + " degrees\n";
        return string;
    }

    public void parseArgs(String[] stringArray) {
        System.out.println("Getting center coordinates...");
        this.centerX = Double.parseDouble(stringArray[0]);
        this.centerY = Double.parseDouble(stringArray[1]);
        this.rotation = Double.parseDouble(stringArray[2]);
        System.out.println("Forcing bars specified on command line...");
        int n = 3;
        while (n < stringArray.length) {
            long l = Integer.parseInt(stringArray[n]);
            boolean bl = MusicalSequence.parseLen(stringArray[n + 1]);
            String string = "";
            string = bl ? "farther" : "closer";
            System.out.println("\tForcing bar " + l + " to be " + string + "...");
            this.force(l, bl);
            n += 2;
        }
    }

    protected static boolean parseLen(String string) {
        if (string.equals("l")) {
            return true;
        }
        if (string.equals("L")) {
            return true;
        }
        if (string.equals("long")) {
            return true;
        }
        if (string.equals("Long")) {
            return true;
        }
        return string.equals("LONG");
    }

    public static void main(String[] stringArray) {
        MusicalSequence musicalSequence = new MusicalSequence();
        musicalSequence.forceAtDistance(PenroseTiling.SHORT);
        System.out.println(musicalSequence.toString(0L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.force(1L, false);
        System.out.println(musicalSequence.toString(0L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.forceAtDistance(PenroseTiling.LONG);
        System.out.println(musicalSequence.toString(0L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.force(1L, true);
        System.out.println(musicalSequence.toString(0L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.forceAtDistance(-PenroseTiling.SHORT);
        System.out.println(musicalSequence.toString(-2L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.force(-1L, false);
        System.out.println(musicalSequence.toString(-2L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.forceAtDistance(-PenroseTiling.LONG);
        System.out.println(musicalSequence.toString(-2L, 3L));
        musicalSequence = new MusicalSequence();
        musicalSequence.force(-1L, true);
        System.out.println(musicalSequence.toString(-2L, 3L));
        musicalSequence.parseArgs(stringArray);
        System.out.println(musicalSequence.toString());
        System.out.println("Hundredth Bar: " + musicalSequence.barToDouble(100L));
        musicalSequence.doubleToBar(musicalSequence.barToDouble(1L));
        musicalSequence.doubleToBar(musicalSequence.barToDouble(10L));
        musicalSequence.doubleToBar(musicalSequence.barToDouble(1000L));
        musicalSequence.doubleToBar(musicalSequence.barToDouble(1000000L));
        System.exit(0);
    }
}

