/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import net.logn.penrose.ForceBarFrame;
import net.logn.penrose.PenrosePanel;
import net.logn.penrose.PenroseTiling;
import net.logn.penrose.ZoomDialog;

public class PenroseApplet
extends JApplet {
    protected static PenroseTiling penroseTiling;
    protected Properties userProperties = null;
    protected static JLabel statusBar;
    protected static PenrosePanel pPanel;
    protected static int currentMode;
    protected static String[] modes;
    public static final int M_DEFAULT = 0;
    public static final int M_MOVE = 1;
    public static final int M_ZOOM = 2;
    public static final int M_ZOOM_IN = 3;
    public static final int M_ZOOM_OUT = 4;
    protected PButton moveButton;
    protected PButton zoomButton;
    protected PButton zoomInButton;
    protected PButton zoomOutButton;
    protected JButton aceButton;
    protected JButton deuceButton;
    protected JButton sunButton;
    protected JButton starButton;
    protected JButton jackButton;
    protected JButton queenButton;
    protected JButton kingButton;
    protected JCheckBox axesButton;
    protected JCheckBox forcedButton;
    protected JCheckBox unforcedButton;
    protected JCheckBox intersectionsButton;
    protected JCheckBox kitesButton;
    protected JCheckBox dartsButton;
    protected JButton refreshButton;
    protected JButton recomputeButton;
    protected JButton forceButton;
    protected JCheckBox fillTilesButton;
    protected JCheckBox markCenterButton;
    protected JCheckBox printColorButton;
    protected JRadioButton tileButton;
    protected JRadioButton rhombButton;

    public PenroseApplet() {
    }

    public PenroseApplet(Properties properties) {
        this.userProperties = properties;
        if (this.userProperties == null) {
            this.userProperties = new Properties();
        }
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.getAccessibleContext().setAccessibleDescription("File Operations");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open Tiling Configuration");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(PenroseApplet.this, "Do you want to destroy the current empire settings?", "Are you sure?", 0);
                if (n == 0) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n2 = jFileChooser.showOpenDialog(PenroseApplet.this);
                    if (n2 == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            penroseTiling.loadConfiguration(file);
                        }
                        catch (IOException iOException) {
                            statusBar.setText("Error Opening " + file.getName() + "!");
                            System.err.println("Error Opening " + file.getName() + ": " + iOException.getMessage());
                        }
                    } else {
                        statusBar.setText("Open command cancelled by user.");
                    }
                    pPanel.redraw();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Tiling Configuration");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        penroseTiling.saveConfiguration(file);
                        statusBar.setText("Saved to " + file.getName());
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Saving " + file.getName() + "!");
                        System.err.println("Error Saving " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Save command cancelled by user.");
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Open System Properties...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Properties properties = new Properties();
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        properties.load(fileInputStream);
                        penroseTiling.loadProperties(properties);
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Loading " + file.getName() + "!");
                        System.err.println("Error Loading " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Load command cancelled by user.");
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save System Properties...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        penroseTiling.saveProperties(file);
                        statusBar.setText("Saved to " + file.getName());
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Saving " + file.getName() + "!");
                        System.err.println("Error Saving " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Save command cancelled by user.");
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Export Rendering");
        jMenu2.setMnemonic(69);
        jMenuItem = new JMenuItem("PNG (requires JAI)");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        penroseTiling.exportPNG(file, pPanel.getWidth(), pPanel.getHeight());
                        statusBar.setText("Saved to " + file.getName());
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Exporting to " + file.getName() + "!");
                        System.err.println("Error Exporting to " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Export command cancelled by user.");
                }
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("EPS");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        penroseTiling.exportEPS(file);
                        statusBar.setText("Saved to " + file.getName());
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Exporting to " + file.getName() + "!");
                        System.err.println("Error Exporting to " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Export command cancelled by user.");
                }
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("PDF");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(PenroseApplet.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        penroseTiling.exportPDF(file);
                        statusBar.setText("Saved to " + file.getName());
                    }
                    catch (IOException iOException) {
                        statusBar.setText("Error Exporting to " + file.getName() + "!");
                        System.err.println("Error Exporting to " + file.getName() + ": " + iOException.getMessage());
                    }
                } else {
                    statusBar.setText("Export command cancelled by user.");
                }
            }
        });
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                penroseTiling.print();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        jMenuItem.getAccessibleContext().setAccessibleDescription("Quits the Program");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Color");
        jMenu.setMnemonic(67);
        jMenu.getAccessibleContext().setAccessibleDescription("Set the colors used by the software");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Background");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the background color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseTiling.backgroundColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Background Color", PenroseTiling.backgroundColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Axes");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the axes color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.axesColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Axes Color", PenroseApplet.penroseTiling.axesColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Forced Bars");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the forced bar color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.forcedColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Forced Bar Color", PenroseApplet.penroseTiling.forcedColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Unforced Bars");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the unforced bar color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.unforcedColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Unforced Bar Color", PenroseApplet.penroseTiling.unforcedColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Intersections");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the intersections color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.intersectionsColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Intersections Color", PenroseApplet.penroseTiling.intersectionsColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Kites");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the Kite Color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.kitesColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Kite Color", PenroseApplet.penroseTiling.kitesColor);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Darts");
        jMenuItem.getAccessibleContext().setAccessibleDescription("Sets the Dart Color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.penroseTiling.dartsColor = JColorChooser.showDialog(PenroseApplet.this, "Choose Dart Color", PenroseApplet.penroseTiling.dartsColor);
            }
        });
        jMenu.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    public void init() {
        String[] stringArray;
        if (this.userProperties == null) {
            this.userProperties = new Properties();
            stringArray = new String[]{"debug", "llx", "lly", "urx", "ury", "drawAxes", "drawForced", "drawUnforced", "drawIntersections", "drawKites", "drawDarts", "markCenter", "fillTiles", "exportColor", "backgroundColor", "axesColor", "forcedColor", "unforcedColor", "intersectionsColor", "kitesColor", "dartsColor", "fillTransparency"};
            int n = 0;
            while (n < stringArray.length) {
                String string = this.getParameter(stringArray[n]);
                if (string != null) {
                    this.userProperties.setProperty(stringArray[n], string);
                }
                ++n;
            }
        }
        penroseTiling.loadProperties(this.userProperties);
        this.getContentPane().setLayout(new BorderLayout());
        pPanel = new PenrosePanel();
        pPanel.setBackground(PenroseTiling.backgroundColor);
        this.getContentPane().add(pPanel);
        stringArray = new JToolBar(0);
        this.addButtons((JToolBar)stringArray);
        this.getContentPane().add("North", (Component)stringArray);
        JToolBar jToolBar = new JToolBar(1);
        this.addCheckBoxes(jToolBar);
        this.getContentPane().add("East", jToolBar);
        statusBar = new JLabel(modes[0]);
        this.getContentPane().add("South", statusBar);
    }

    protected void addButtons(JToolBar jToolBar) {
        ButtonListener buttonListener = new ButtonListener();
        JLabel jLabel = new JLabel("Tools:");
        jToolBar.add(jLabel);
        jToolBar.addSeparator(new Dimension(10, 10));
        this.moveButton = new PButton("icons/move");
        this.moveButton.setMode(1);
        this.moveButton.setMnemonic(77);
        this.moveButton.setToolTipText("Move viewpoint");
        this.moveButton.addActionListener(buttonListener);
        jToolBar.add(this.moveButton);
        this.zoomInButton = new PButton("icons/zoomIn");
        this.zoomInButton.setMode(3);
        this.zoomInButton.setMnemonic(61);
        this.zoomInButton.setToolTipText("Zoom in 2x");
        this.zoomInButton.addActionListener(buttonListener);
        jToolBar.add(this.zoomInButton);
        this.zoomButton = new PButton("icons/zoom");
        this.zoomButton.setMode(2);
        this.zoomButton.setMnemonic(90);
        this.zoomButton.setToolTipText("Zoom By An Arbitrary Amount");
        this.zoomButton.addActionListener(buttonListener);
        this.zoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = pPanel.getZoom();
                ZoomDialog zoomDialog = new ZoomDialog(d);
                zoomDialog.pack();
                ((Component)zoomDialog).setVisible(true);
                d = zoomDialog.getValidatedZoom();
                pPanel.setZoom(d);
            }
        });
        jToolBar.add(this.zoomButton);
        this.zoomOutButton = new PButton("icons/zoomOut");
        this.zoomOutButton.setMode(4);
        this.zoomOutButton.setMnemonic(45);
        this.zoomOutButton.setToolTipText("Zoom Out 2x");
        this.zoomOutButton.addActionListener(buttonListener);
        jToolBar.add(this.zoomOutButton);
        jToolBar.add(new Box.Filler(new Dimension(20, 10), new Dimension(50, 10), new Dimension(150, 150)));
        JLabel jLabel2 = new JLabel("Vertex Configurations:");
        jToolBar.add(jLabel2);
        jToolBar.addSeparator(new Dimension(10, 10));
        this.aceButton = new JButton(PenroseApplet.classIcon("icons/ace.gif"));
        this.aceButton.setMnemonic(49);
        this.aceButton.setToolTipText("Generate Ace Configuration");
        this.aceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(0);
            }
        });
        jToolBar.add(this.aceButton);
        this.deuceButton = new JButton(PenroseApplet.classIcon("icons/deuce.gif"));
        this.deuceButton.setMnemonic(50);
        this.deuceButton.setToolTipText("Generate Deuce Configuration");
        this.deuceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(1);
            }
        });
        jToolBar.add(this.deuceButton);
        this.sunButton = new JButton(PenroseApplet.classIcon("icons/sun.gif"));
        this.sunButton.setMnemonic(51);
        this.sunButton.setToolTipText("Generate Sun Configuration");
        this.sunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(2);
            }
        });
        jToolBar.add(this.sunButton);
        this.starButton = new JButton(PenroseApplet.classIcon("icons/star.gif"));
        this.starButton.setMnemonic(52);
        this.starButton.setToolTipText("Generate Star Configuration");
        this.starButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(3);
            }
        });
        jToolBar.add(this.starButton);
        this.jackButton = new JButton(PenroseApplet.classIcon("icons/jack.gif"));
        this.jackButton.setMnemonic(53);
        this.jackButton.setToolTipText("Generate Jack Configuration");
        this.jackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(4);
            }
        });
        jToolBar.add(this.jackButton);
        this.queenButton = new JButton(PenroseApplet.classIcon("icons/queen.gif"));
        this.queenButton.setMnemonic(54);
        this.queenButton.setToolTipText("Generate Queen Configuration");
        this.queenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(5);
            }
        });
        jToolBar.add(this.queenButton);
        this.kingButton = new JButton(PenroseApplet.classIcon("icons/king.gif"));
        this.kingButton.setMnemonic(55);
        this.kingButton.setToolTipText("Generate King Configuration");
        this.kingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApplet.this.newVertex(6);
            }
        });
        jToolBar.add(this.kingButton);
    }

    protected void newVertex(int n) {
        int n2 = JOptionPane.showConfirmDialog(this, "Do you want to destroy the current empire settings?", "Are you sure?", 0);
        if (n2 == 0) {
            penroseTiling.setInitialConfiguration(n);
            pPanel.redraw();
        }
    }

    protected void addCheckBoxes(JToolBar jToolBar) {
        ButtonListener buttonListener = new ButtonListener();
        this.axesButton = new JCheckBox("Axes");
        this.axesButton.setMnemonic(65);
        this.axesButton.setSelected(penroseTiling.drawAxes());
        this.axesButton.setToolTipText("Axes will be drawn");
        this.axesButton.addItemListener(buttonListener);
        jToolBar.add(this.axesButton);
        this.forcedButton = new JCheckBox("Forced Bars");
        this.forcedButton.setMnemonic(70);
        this.forcedButton.setSelected(penroseTiling.drawForced());
        this.forcedButton.setToolTipText("Forced bars will be drawn");
        this.forcedButton.addItemListener(buttonListener);
        jToolBar.add(this.forcedButton);
        this.unforcedButton = new JCheckBox("Unforced Bars");
        this.unforcedButton.setMnemonic(85);
        this.unforcedButton.setSelected(penroseTiling.drawUnforced());
        this.unforcedButton.setToolTipText("Unforced bars will be drawn");
        this.unforcedButton.addItemListener(buttonListener);
        jToolBar.add(this.unforcedButton);
        this.intersectionsButton = new JCheckBox("Intersections");
        this.intersectionsButton.setMnemonic(73);
        this.intersectionsButton.setSelected(penroseTiling.drawIntersections());
        this.intersectionsButton.setToolTipText("Intersections will be drawn");
        this.intersectionsButton.addItemListener(buttonListener);
        jToolBar.add(this.intersectionsButton);
        this.kitesButton = new JCheckBox("Kites");
        this.kitesButton.setMnemonic(75);
        this.kitesButton.setSelected(penroseTiling.drawKites());
        this.kitesButton.setToolTipText("Kites will be drawn");
        this.kitesButton.addItemListener(buttonListener);
        jToolBar.add(this.kitesButton);
        this.dartsButton = new JCheckBox("Darts");
        this.dartsButton.setMnemonic(68);
        this.dartsButton.setSelected(penroseTiling.drawDarts());
        this.dartsButton.setToolTipText("Darts will be drawn");
        this.dartsButton.addItemListener(buttonListener);
        jToolBar.add(this.dartsButton);
        this.refreshButton = new JButton("Refresh Empire");
        this.refreshButton.setMnemonic(82);
        this.refreshButton.setToolTipText("Refresh Empire (without finding new forcings)");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pPanel.redraw();
            }
        });
        jToolBar.add(this.refreshButton);
        this.recomputeButton = new JButton("Recompute Empire");
        this.recomputeButton.setMnemonic(67);
        this.recomputeButton.setToolTipText("Recompute Empire (may take a LONG time!)");
        this.recomputeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pPanel.recompute();
                pPanel.redraw();
            }
        });
        jToolBar.add(this.recomputeButton);
        jToolBar.add(new Box.Filler(new Dimension(10, 10), new Dimension(20, 40), new Dimension(40, 80)));
        this.forceButton = new JButton("Force Arbitrary");
        this.forceButton.setMnemonic(78);
        this.forceButton.setToolTipText("Force New Arbitrary Bars");
        this.forceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForceBarFrame forceBarFrame = new ForceBarFrame(PenroseApplet.this);
                ((Component)forceBarFrame).setSize(new Dimension(400, 150));
                forceBarFrame.show();
            }
        });
        jToolBar.add(this.forceButton);
        jToolBar.add(new Box.Filler(new Dimension(10, 10), new Dimension(20, 40), new Dimension(40, 80)));
        this.fillTilesButton = new JCheckBox("Fill Tiles");
        this.fillTilesButton.setSelected(penroseTiling.fillTiles());
        this.fillTilesButton.setToolTipText("Tiles will be filled");
        this.fillTilesButton.addItemListener(buttonListener);
        jToolBar.add(this.fillTilesButton);
        this.markCenterButton = new JCheckBox("Mark Center");
        this.markCenterButton.setSelected(penroseTiling.markCenter());
        this.markCenterButton.setToolTipText("Set whether to mark the center of the image");
        this.markCenterButton.addItemListener(buttonListener);
        jToolBar.add(this.markCenterButton);
        this.printColorButton = new JCheckBox("Export in Color");
        this.printColorButton.setSelected(penroseTiling.exportColor());
        this.printColorButton.setToolTipText("Set whether to print and export in color");
        this.printColorButton.addItemListener(buttonListener);
        jToolBar.add(this.printColorButton);
    }

    public static ImageIcon classIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = ClassLoader.getSystemResource("net/logn/penrose/" + string);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    public static void main(String[] stringArray) {
        Object object;
        JFrame jFrame = new JFrame("Penrose Applet With Extensions");
        Properties properties = new Properties();
        if (stringArray.length > 0) {
            if (stringArray.length > 1) {
                System.out.println("PenroseApplet takes one optional argument.  Ignoring other arguments...");
            }
            try {
                object = new FileInputStream(stringArray[0]);
                properties.load((InputStream)object);
            }
            catch (IOException iOException) {
                System.err.println("Error reading properties file '" + stringArray[0] + "'.\n\nUsing Defaults...");
            }
        }
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        object = new PenroseApplet(properties);
        jFrame.getContentPane().add("Center", (Component)object);
        ((Applet)object).init();
        jFrame.pack();
        ((Component)jFrame).setSize(new Dimension(640, 480));
        jFrame.show();
    }

    static {
        currentMode = 0;
        penroseTiling = new PenroseTiling();
        modes = new String[6];
        PenroseApplet.modes[0] = "Penrose Empire Applet: http://www.logn.net/penrose/";
        PenroseApplet.modes[1] = "Click and drag to reposition viewing canvas";
        PenroseApplet.modes[2] = "Click to zoom";
        PenroseApplet.modes[3] = "Click to zoom in 2x";
        PenroseApplet.modes[4] = "Click to zoom out 2x";
    }

    class ButtonListener
    implements ItemListener,
    ActionListener {
        PButton active = null;

        ButtonListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = false;
            if (itemEvent.getStateChange() == 1) {
                bl = true;
            }
            if (itemSelectable == PenroseApplet.this.axesButton) {
                penroseTiling.drawAxes(bl);
            } else if (itemSelectable == PenroseApplet.this.forcedButton) {
                penroseTiling.drawForced(bl);
            } else if (itemSelectable == PenroseApplet.this.unforcedButton) {
                penroseTiling.drawUnforced(bl);
            } else if (itemSelectable == PenroseApplet.this.intersectionsButton) {
                penroseTiling.drawIntersections(bl);
            } else if (itemSelectable == PenroseApplet.this.kitesButton) {
                penroseTiling.drawKites(bl);
            } else if (itemSelectable == PenroseApplet.this.dartsButton) {
                penroseTiling.drawDarts(bl);
            } else if (itemSelectable == PenroseApplet.this.fillTilesButton) {
                penroseTiling.fillTiles(bl);
            } else if (itemSelectable == PenroseApplet.this.markCenterButton) {
                penroseTiling.markCenter(bl);
            } else if (itemSelectable == PenroseApplet.this.printColorButton) {
                penroseTiling.exportColor(bl);
            } else if (itemSelectable == PenroseApplet.this.tileButton) {
                penroseTiling.tilesNotRhombs(bl);
            } else if (itemSelectable == PenroseApplet.this.rhombButton) {
                penroseTiling.tilesNotRhombs(!bl);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            PButton pButton = (PButton)actionEvent.getSource();
            currentMode = n = pButton.getMode();
            statusBar.setText(modes[currentMode]);
            if (this.active != null) {
                this.active.swap();
            }
            this.active = pButton;
            this.active.swap();
        }
    }

    class PButton
    extends JButton {
        protected int mode = 0;
        protected Icon inactive = null;

        public PButton(Icon icon) {
            super(icon);
        }

        public PButton(String string) {
            super(PenroseApplet.classIcon(string + ".gif"));
            this.inactive = PenroseApplet.classIcon(string + "Selected.gif");
        }

        public void setMode(int n) {
            this.mode = n;
        }

        public int getMode() {
            return this.mode;
        }

        public void swap() {
            if (this.inactive != null) {
                Icon icon = this.getIcon();
                this.setIcon(this.inactive);
                this.inactive = icon;
            }
        }
    }
}

