/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.logn.penrose.PenroseApplet;
import net.logn.penrose.PenroseTiling;

public class PenrosePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected BufferedImage viewport;
    protected AffineTransform previewTransform;
    protected AffineTransform viewportTransform;
    protected int appWidth;
    protected int appHeight;
    protected double centerX;
    protected double centerY;
    protected double scale;
    protected double zoomFactor;
    private int pressX;
    private int pressY;
    private int releaseX;
    private int releaseY;
    private static final Point2D.Double zero = new Point2D.Double(0.0, 0.0);
    private Point2D.Double press = zero;
    private Point2D.Double release = zero;
    private Point2D.Double center = zero;

    public PenrosePanel() {
        this.setBackground(PenroseTiling.backgroundColor);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.viewportTransform = new AffineTransform();
        this.previewTransform = new AffineTransform();
        this.scale = 100.0;
        this.zoomFactor = 1.0;
        this.viewport = new BufferedImage(1, 1, 1);
    }

    protected void recalc() {
        this.viewportTransform = new AffineTransform();
        this.appWidth = this.getWidth();
        this.appHeight = this.getHeight();
        PenroseApplet.penroseTiling.setDimensions((double)this.appWidth / this.scale, (double)this.appHeight / this.scale);
        PenroseApplet.penroseTiling.setOffset(this.center.getX(), this.center.getY());
        this.viewportTransform.scale(this.scale, this.scale);
        this.viewportTransform.translate((double)this.appWidth / (2.0 * this.scale), (double)this.appHeight / (2.0 * this.scale));
        this.viewportTransform.translate(-this.center.getX(), -this.center.getY());
    }

    public void recompute() {
        this.recalc();
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setTransform(this.viewportTransform);
        PenroseApplet.penroseTiling.recomputeEmpire(graphics2D);
    }

    public void redraw() {
        this.recalc();
        this.viewport = new BufferedImage(this.appWidth, this.appHeight, 1);
        Graphics2D graphics2D = this.viewport.createGraphics();
        graphics2D.setBackground(PenroseTiling.backgroundColor);
        graphics2D.clearRect(0, 0, this.appWidth, this.appHeight);
        graphics2D.setTransform(this.viewportTransform);
        PenroseApplet.penroseTiling.renderTiling(graphics2D);
        this.previewTransform = new AffineTransform();
        this.releaseX = this.pressX;
        this.releaseY = this.pressY;
        this.repaint();
    }

    public void paintShape(Shape shape, Color color, boolean bl) {
        this.recalc();
        this.viewport = new BufferedImage(this.appWidth, this.appHeight, 1);
        Graphics2D graphics2D = this.viewport.createGraphics();
        graphics2D.setBackground(PenroseTiling.backgroundColor);
        graphics2D.clearRect(0, 0, this.appWidth, this.appHeight);
        graphics2D.setTransform(this.viewportTransform);
        PenroseApplet.penroseTiling.renderTiling(graphics2D);
        this.previewTransform = new AffineTransform();
        this.releaseX = this.pressX;
        this.releaseY = this.pressY;
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(shape);
        } else {
            graphics2D.draw(shape);
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawRenderedImage(this.viewport, this.previewTransform);
    }

    public void setZoom(double d) {
        this.zoomFactor = d == 1.0 && this.scale != 1.0 ? 1.0 / this.scale : d;
    }

    public double getZoom() {
        return this.zoomFactor;
    }

    public void zoom() {
        double d = this.previewTransform.getTranslateX();
        double d2 = this.previewTransform.getTranslateY();
        double d3 = ((double)(this.appWidth / 2) - d) / this.previewTransform.getScaleX();
        double d4 = ((double)(this.appHeight / 2) - d2) / this.previewTransform.getScaleY();
        double d5 = (1.0 - this.zoomFactor) * d3;
        double d6 = (1.0 - this.zoomFactor) * d4;
        this.previewTransform.translate(d5, d6);
        this.scale *= this.zoomFactor;
        this.previewTransform.scale(this.zoomFactor, this.zoomFactor);
        this.repaint();
    }

    public Point2D.Double screenToPenrose(int n, int n2) {
        Point2D.Double double_ = new Point2D.Double(n, n2);
        return PenrosePanel.screenToPenrose(double_, this.viewportTransform);
    }

    public static Point2D.Double screenToPenrose(Point2D.Double double_, AffineTransform affineTransform) {
        try {
            Point2D.Double double_2 = (Point2D.Double)affineTransform.inverseTransform(double_, null);
            return double_2;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Point2D.Double(0.0, 0.0);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressX = mouseEvent.getX();
        this.pressY = mouseEvent.getY();
        this.press = this.screenToPenrose(this.pressX, this.pressY);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.releaseX = mouseEvent.getX();
        this.releaseY = mouseEvent.getY();
        this.previewTransform.translate((double)(this.releaseX - this.pressX) / this.previewTransform.getScaleX(), (double)(this.releaseY - this.pressY) / this.previewTransform.getScaleY());
        this.pressX = this.releaseX;
        this.pressY = this.releaseY;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.releaseX = mouseEvent.getX();
        this.releaseY = mouseEvent.getY();
        this.release = this.screenToPenrose(this.releaseX, this.releaseY);
        this.previewTransform.translate((double)(this.releaseX - this.pressX) / this.previewTransform.getScaleX(), (double)(this.releaseY - this.pressY) / this.previewTransform.getScaleY());
        this.pressX = this.releaseX;
        this.pressY = this.releaseY;
        double d = this.press.getX() - this.release.getX();
        double d2 = this.press.getY() - this.release.getY();
        this.center = new Point2D.Double(this.center.getX() + d, this.center.getY() + d2);
        this.recalc();
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point2D.Double double_ = this.screenToPenrose(mouseEvent.getX(), mouseEvent.getY());
        PenroseApplet.statusBar.setText("Penrose Coordinates: " + ((Point2D)double_).getX() + ", " + ((Point2D)double_).getY());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.pressX = mouseEvent.getX();
        this.pressY = mouseEvent.getY();
        this.center = this.screenToPenrose(this.pressX, this.pressY);
        this.previewTransform.translate((double)(this.appWidth / 2 - this.pressX) / this.previewTransform.getScaleX(), (double)(this.appHeight / 2 - this.pressY) / this.previewTransform.getScaleY());
        switch (PenroseApplet.currentMode) {
            case 3: {
                this.setZoom(2.0);
                this.zoom();
                break;
            }
            case 4: {
                this.setZoom(0.5);
                this.zoom();
                break;
            }
            case 2: {
                this.zoom();
                break;
            }
            default: {
                PenroseApplet.statusBar.setText("Recentered At Penrose Coordinates: " + this.center.getX() + ", " + this.center.getY());
            }
        }
        this.recalc();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        PenroseApplet.statusBar.setText(PenroseApplet.modes[PenroseApplet.currentMode]);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

