/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.Vector;
import net.logn.penrose.Constellation;
import net.logn.penrose.Dart;
import net.logn.penrose.DoubleKite;
import net.logn.penrose.FiveFold;
import net.logn.penrose.IntersectionPoint;
import net.logn.penrose.Kite;
import net.logn.util.vectoroutput.PDF;
import net.logn.util.vectoroutput.PNG;
import net.logn.util.vectoroutput.Postscript;
import net.logn.util.vectoroutput.VectorOutput;

public class PenroseTiling
implements Printable {
    protected static final double TAU = (1.0 + Math.sqrt(5.0)) / 2.0;
    public static final double EPSILON = 1.0E-10;
    public static final boolean LONGER = true;
    public static final boolean SHORTER = false;
    public static final double MINNICK_A = PenroseTiling.sin(54.0) * (1.0 + PenroseTiling.cos(72.0));
    public static final double MINNICK_B = 0.25;
    public static final double MINNICK_C = PenroseTiling.cos(36.0) + 0.75;
    public static final double MINNICK_D = MINNICK_A - 1.0;
    public static final double MINNICK_E = TAU - 0.25;
    public static final double MINNICK_V = 0.25 * (3.0 - PenroseTiling.tan(36.0) / PenroseTiling.tan(18.0));
    public static final double MINNICK_W = 0.75;
    public static final double MINNICK_X = 1.0 + PenroseTiling.cos(72.0);
    public static final double MINNICK_Y = PenroseTiling.cos(72.0);
    public static final double MINNICK_Z = 0.25;
    public static final double SCALE;
    public static final double SHORT;
    public static final double LONG;
    public static final double INITIAL_LEFT = -7.0;
    public static final double INITIAL_TOP = -7.0;
    public static final double INITIAL_RIGHT = 7.0;
    public static final double INITIAL_BOTTOM = 7.0;
    public static final double BOX_OVERLAP = 2.126627021;
    public static final double BOX_DIM = 10.0;
    public static final double BOX_ORIGIN = -5.0;
    public static final double ITERATE_OVERLAP = 3.44;
    public static final double ITERATE_DIM = 100.0;
    public static final int ACE = 0;
    public static final int DEUCE = 1;
    public static final int SUN = 2;
    public static final int STAR = 3;
    public static final int JACK = 4;
    public static final int QUEEN = 5;
    public static final int KING = 6;
    protected static double width;
    protected static double height;
    protected static double xOffset;
    protected static double yOffset;
    private boolean searched = false;
    public static int DEBUG;
    protected PageFormat pageSetup = null;
    protected FiveFold fiveFold;
    protected Line2D[] axes = new Line2D[0];
    protected Line2D[] forcedBars = new Line2D[0];
    protected Line2D[] unforcedBars = new Line2D[0];
    protected Ellipse2D[] intersections = new Ellipse2D[0];
    protected Kite[] kiteTiles = new Kite[0];
    protected Dart[] dartTiles = new Dart[0];
    protected int numTiles = 0;
    protected long time;
    protected boolean drawAxes = false;
    protected boolean drawForced = true;
    protected boolean drawUnforced = false;
    protected boolean drawIntersections = true;
    protected boolean drawKites = true;
    protected boolean drawDarts = true;
    protected boolean fillTiles = true;
    protected static boolean tilesNotRhombs;
    protected boolean exportColor = true;
    protected boolean markCenter = true;
    protected static Color backgroundColor;
    protected Color axesColor = Color.yellow;
    protected Color forcedColor = Color.black;
    protected Color unforcedColor = Color.orange;
    protected Color intersectionsColor = Color.red;
    protected Color kitesColor = Color.blue;
    protected Color dartsColor = Color.green;
    protected double fillTransparency = 0.2;
    public static final BasicStroke STROKE_DEFAULT;
    public static final AlphaComposite ALPHA_SCREEN;
    public static final AlphaComposite ALPHA_PRINT;
    protected AlphaComposite ALPHA_OVERLAY = AlphaComposite.getInstance(3, (float)this.fillTransparency);
    public static final AlphaComposite ALPHA_DEFAULT;
    public static RenderingHints RENDER_SCREEN;
    public static RenderingHints RENDER_PRINT;
    public static RenderingHints RENDER_DEFAULT;

    public PenroseTiling() {
        this.setInitialConfiguration(2);
    }

    public PenroseTiling(int n) {
        this();
        this.setInitialConfiguration(n);
    }

    public void saveConfiguration(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.fiveFold);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public void loadConfiguration(File file) throws IOException {
        FiveFold fiveFold;
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            fiveFold = (FiveFold)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            fiveFold = null;
        }
        fileInputStream.close();
        this.setInitialConfiguration(fiveFold);
    }

    public void setInitialConfiguration(int n) {
        FiveFold fiveFold = null;
        switch (n) {
            case 0: {
                fiveFold = PenroseTiling.aceConfiguration();
                break;
            }
            case 1: {
                fiveFold = PenroseTiling.deuceConfiguration();
                break;
            }
            case 2: {
                fiveFold = PenroseTiling.sunConfiguration();
                break;
            }
            case 3: {
                fiveFold = PenroseTiling.starConfiguration();
                break;
            }
            case 4: {
                fiveFold = PenroseTiling.jackConfiguration();
                break;
            }
            case 5: {
                fiveFold = PenroseTiling.queenConfiguration();
                break;
            }
            case 6: {
                fiveFold = PenroseTiling.kingConfiguration();
            }
        }
        if (fiveFold != null) {
            this.setInitialConfiguration(fiveFold);
        }
    }

    public void setInitialConfiguration(FiveFold fiveFold) {
        this.fiveFold = fiveFold;
        this.intersections = new Ellipse2D[0];
        this.kiteTiles = new Kite[0];
        this.dartTiles = new Dart[0];
        double[] dArray = this.getBoundingBox();
        this.axes = this.fiveFold.getAxes(dArray[0], dArray[1], dArray[2], dArray[3]);
        this.forcedBars = this.fiveFold.getForcedLines(dArray[0], dArray[1], dArray[2], dArray[3]);
        this.unforcedBars = this.fiveFold.getUnforcedLines(dArray[0], dArray[1], dArray[2], dArray[3]);
        this.searched = false;
    }

    public void getInitialConfiguration(double[][] dArray, long[][] lArray, boolean[][] blArray) {
        if (dArray.length != 5 || lArray.length != 5 || blArray.length != 5) {
            System.err.println("Error!  Cannot set initial configuration.\nIncorrect number of Musical Sequence \nconfigurations provided");
        } else {
            this.fiveFold = new FiveFold();
            int n = 0;
            while (n < 5) {
                this.fiveFold.sequences[n].centerX = dArray[n][0];
                this.fiveFold.sequences[n].centerY = dArray[n][1];
                int n2 = 0;
                while (n2 < lArray[n].length) {
                    this.fiveFold.sequences[n].force(lArray[n][n2], blArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public static FiveFold aceConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(MINNICK_A);
        fiveFold.sequences[1].setZeroBar(MINNICK_A);
        fiveFold.sequences[2].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[3].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[4].setZeroBar(MINNICK_A);
        return fiveFold;
    }

    public static FiveFold deuceConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(MINNICK_A);
        fiveFold.sequences[1].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[2].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[3].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[4].setZeroBar(MINNICK_A);
        return fiveFold;
    }

    public static FiveFold sunConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(0.25);
        fiveFold.sequences[1].setZeroBar(0.25);
        fiveFold.sequences[2].setZeroBar(0.25);
        fiveFold.sequences[3].setZeroBar(0.25);
        fiveFold.sequences[4].setZeroBar(0.25);
        return fiveFold;
    }

    public static FiveFold starConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[0].force(1L, true);
        fiveFold.sequences[1].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[1].force(1L, true);
        fiveFold.sequences[2].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[2].force(1L, true);
        fiveFold.sequences[3].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[3].force(1L, true);
        fiveFold.sequences[4].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[4].force(1L, true);
        return fiveFold;
    }

    public static FiveFold jackConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(MINNICK_E);
        fiveFold.sequences[0].force(-1L, true);
        fiveFold.sequences[1].setZeroBar(0.25);
        fiveFold.sequences[1].force(-1L, true);
        fiveFold.sequences[2].setZeroBar(0.25);
        fiveFold.sequences[3].setZeroBar(0.25);
        fiveFold.sequences[4].setZeroBar(0.25);
        fiveFold.sequences[4].force(-1L, true);
        return fiveFold;
    }

    public static FiveFold queenConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(MINNICK_A);
        fiveFold.sequences[1].setZeroBar(-0.75);
        fiveFold.sequences[1].force(1L, false);
        fiveFold.sequences[2].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[2].force(1L, true);
        fiveFold.sequences[3].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[3].force(1L, true);
        fiveFold.sequences[4].setZeroBar(-0.75);
        fiveFold.sequences[4].force(1L, false);
        return fiveFold;
    }

    public static FiveFold kingConfiguration() {
        FiveFold fiveFold = new FiveFold();
        fiveFold.sequences[0].setZeroBar(-0.75);
        fiveFold.sequences[0].force(1L, false);
        fiveFold.sequences[1].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[1].force(1L, true);
        fiveFold.sequences[2].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[2].force(1L, true);
        fiveFold.sequences[3].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[3].force(1L, true);
        fiveFold.sequences[4].setZeroBar(-(MINNICK_X + MINNICK_Y + 0.25));
        fiveFold.sequences[4].force(1L, true);
        return fiveFold;
    }

    public void setDimensions(double d, double d2) {
        width = d;
        height = d2;
    }

    public void setOffset(double d, double d2) {
        xOffset = d;
        yOffset = d2;
    }

    public void setOffset(AffineTransform affineTransform) {
        this.setOffset(affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public void recomputeEmpire() {
        this.recomputeEmpire(null);
    }

    public void recomputeEmpire(Graphics2D graphics2D) {
        if (!this.searched) {
            this.recomputeArea(-7.0, -7.0, 7.0, 7.0, null);
            this.searched = true;
        }
        double d = xOffset - width / 2.0 - 2.126627021;
        double d2 = yOffset - height / 2.0 - 2.126627021;
        double d3 = d + width + 4.253254042;
        double d4 = d2 + height + 4.253254042;
        if (graphics2D != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
            graphics2D.setComposite(ALPHA_SCREEN);
            graphics2D.setColor(backgroundColor);
            graphics2D.fill(double_);
        }
        this.recomputeArea(d, d2, d3, d4, graphics2D);
        this.axes = this.fiveFold.getAxes(d, d2, d3, d4);
        this.forcedBars = this.fiveFold.getForcedLines(d, d2, d3, d4);
        this.unforcedBars = this.fiveFold.getUnforcedLines(d, d2, d3, d4);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void recomputeArea(double var1_1, double var3_3, double var5_4, double var7_5, Graphics2D var9_2) {
        if (var9_2 != null) {
            var9_2.setRenderingHints(PenroseTiling.RENDER_DEFAULT);
            var9_2.setStroke(PenroseTiling.STROKE_DEFAULT);
            var9_2.setComposite(this.ALPHA_OVERLAY);
        }
        var10_6 = true;
        var11_7 = new Vector<E>(0);
        var12_8 /* !! */  = new Vector<E>(0);
        var13_9 /* !! */  = new Vector<E>(0);
        var14_10 = null;
        var15_11 = null;
        while (var10_6) {
            block11: {
                var10_6 = false;
                var14_10 = this.fiveFold.findIntersectionPoints(var1_1, var3_3, var5_4, var7_5);
                this.intersections = new Ellipse2D[var14_10.size()];
                var16_12 = 0;
                var17_13 = var14_10.iterator();
                var15_11 = new Vector<IntersectionPoint>();
                var18_14 = -1.0;
                var20_16 = -1.0;
                if (var9_2 == null) ** GOTO lbl50
                var9_2.setComposite(this.ALPHA_OVERLAY);
                var22_17 /* !! */  = null;
                while (var17_13.hasNext()) {
                    var23_18 = (IntersectionPoint)var17_13.next();
                    if (var23_18.boxLayer != var18_14 || var23_18.boxTheta != var20_16) {
                        var18_14 = var23_18.boxLayer;
                        var20_16 = var23_18.boxTheta;
                        var15_11.add(var23_18);
                        var22_17 /* !! */  = null;
                    }
                    if (var22_17 /* !! */  == null) {
                        var9_2.setColor(Color.cyan);
                        var22_17 /* !! */  = var23_18.getBoxRect();
                        if (var22_17 /* !! */  != null) {
                            var9_2.fill((Shape)var22_17 /* !! */ );
                        }
                    }
                    this.intersections[var16_12] = var24_19 = var23_18.getShape();
                    ++var16_12;
                    var9_2.setColor(this.intersectionsColor);
                    var9_2.fill(var24_19);
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    var22_17 /* !! */  = (IntersectionPoint)var17_13.next();
                    if (var22_17 /* !! */ .boxLayer == var18_14 && var22_17 /* !! */ .boxTheta == var20_16) continue;
                    var18_14 = var22_17 /* !! */ .boxLayer;
                    var20_16 = var22_17 /* !! */ .boxTheta;
                    var15_11.add(var22_17 /* !! */ );
                    this.intersections[var16_12] = var22_17 /* !! */ .getShape();
                    ++var16_12;
lbl50:
                    // 3 sources

                    ** while (var17_13.hasNext())
                }
            }
            if (var9_2 != null) {
                var9_2.setColor(this.dartsColor);
            }
            var12_8 /* !! */  = Dart.getConstellations(var14_10, this.fiveFold, var15_11, var9_2);
            var13_9 /* !! */  = DoubleKite.getConstellations(var14_10, this.fiveFold, var15_11, var9_2);
            var10_6 = var10_6 != false || this.forceNew(var12_8 /* !! */ ) != false;
            v0 = var10_6 = var10_6 != false || this.forceNew(var13_9 /* !! */ ) != false;
        }
        if (var9_2 != null) {
            var9_2.setColor(this.kitesColor);
        }
        var11_7 = Kite.getConstellations(var14_10, this.fiveFold, var15_11, var9_2);
        this.kiteTiles = new Kite[var11_7.size()];
        var16_12 = 0;
        var17_13 = var11_7.iterator();
        while (var17_13.hasNext()) {
            this.kiteTiles[var16_12] = (Kite)var17_13.next();
            ++var16_12;
        }
        this.dartTiles = new Dart[var12_8 /* !! */ .size()];
        var18_15 = 0;
        var19_20 = var12_8 /* !! */ .iterator();
        while (var19_20.hasNext()) {
            this.dartTiles[var18_15] = (Dart)var19_20.next();
            ++var18_15;
        }
    }

    public boolean forceNew(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Constellation constellation = (Constellation)iterator.next();
            boolean bl2 = bl = bl || constellation.forceBars(this.fiveFold);
        }
        return bl;
    }

    public void renderTiling(Graphics2D graphics2D) {
        this.renderTiling(graphics2D, STROKE_DEFAULT, ALPHA_DEFAULT, RENDER_DEFAULT);
    }

    public void renderTiling(Graphics2D graphics2D, Stroke stroke, AlphaComposite alphaComposite, RenderingHints renderingHints) {
        int n;
        int n2;
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(stroke);
        graphics2D.setComposite(alphaComposite);
        if (this.drawAxes) {
            graphics2D.setColor(this.axesColor);
            n2 = 0;
            while (n2 < this.axes.length) {
                graphics2D.draw(this.axes[n2]);
                ++n2;
            }
        }
        if (this.drawForced) {
            graphics2D.setColor(this.forcedColor);
            n2 = 0;
            while (n2 < this.forcedBars.length) {
                graphics2D.draw(this.forcedBars[n2]);
                ++n2;
            }
        }
        if (this.drawUnforced) {
            graphics2D.setColor(this.unforcedColor);
            n2 = 0;
            while (n2 < this.unforcedBars.length) {
                graphics2D.draw(this.unforcedBars[n2]);
                ++n2;
            }
        }
        if (this.drawIntersections) {
            graphics2D.setColor(this.intersectionsColor);
            n2 = 0;
            while (n2 < this.intersections.length) {
                graphics2D.draw(this.intersections[n2]);
                ++n2;
            }
        }
        if (this.drawKites) {
            graphics2D.setColor(this.kitesColor);
            n2 = 0;
            while (n2 < this.kiteTiles.length) {
                graphics2D.draw(this.kiteTiles[n2].getShape());
                ++n2;
            }
            if (this.fillTiles) {
                graphics2D.setComposite(this.ALPHA_OVERLAY);
                n = 0;
                while (n < this.kiteTiles.length) {
                    graphics2D.fill(this.kiteTiles[n].getShape());
                    ++n;
                }
                graphics2D.setComposite(alphaComposite);
            }
        }
        if (this.drawDarts) {
            graphics2D.setColor(this.dartsColor);
            n2 = 0;
            while (n2 < this.dartTiles.length) {
                graphics2D.draw(this.dartTiles[n2].getShape());
                ++n2;
            }
            if (this.fillTiles) {
                graphics2D.setComposite(this.ALPHA_OVERLAY);
                n = 0;
                while (n < this.dartTiles.length) {
                    graphics2D.fill(this.dartTiles[n].getShape());
                    ++n;
                }
                graphics2D.setComposite(alphaComposite);
            }
        }
        if (this.markCenter) {
            graphics2D.setComposite(this.ALPHA_OVERLAY);
            graphics2D.setColor(Color.black);
            graphics2D.fillOval(-1, -1, 2, 2);
            graphics2D.setComposite(alphaComposite);
        }
    }

    public String print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }
        return null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d;
        double d2;
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        double d5 = (pageFormat.getWidth() - d3) / 2.0;
        double d6 = (pageFormat.getHeight() - d4) / 2.0;
        graphics2D.translate(d3 / 2.0 + d5, d4 / 2.0 + d6);
        if (DEBUG > 3) {
            System.out.println("Page dimensions: " + d3 + ", " + d4);
        }
        double d7 = (d2 = d3 / width) < (d = d4 / height) ? d2 : d;
        graphics2D.translate(-(xOffset * d7), -(yOffset * d7));
        graphics2D.scale(d7, d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(xOffset - width / 2.0 - 1.0, yOffset - height / 2.0 - 1.0, width + 2.0, height + 2.0);
        if (DEBUG > 3) {
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
        } else {
            graphics2D.clip(double_);
        }
        if (!this.exportColor) {
            Color color = backgroundColor;
            Color color2 = this.axesColor;
            Color color3 = this.forcedColor;
            Color color4 = this.unforcedColor;
            Color color5 = this.intersectionsColor;
            Color color6 = this.kitesColor;
            Color color7 = this.dartsColor;
            backgroundColor = Color.white;
            this.axesColor = Color.black;
            this.forcedColor = Color.black;
            this.unforcedColor = Color.black;
            this.intersectionsColor = Color.black;
            this.kitesColor = Color.black;
            this.dartsColor = Color.black;
            this.renderTiling(graphics2D, STROKE_DEFAULT, ALPHA_PRINT, RENDER_PRINT);
            backgroundColor = color;
            this.axesColor = color2;
            this.forcedColor = color3;
            this.unforcedColor = color4;
            this.intersectionsColor = color5;
            this.kitesColor = color6;
            this.dartsColor = color7;
        } else {
            this.renderTiling(graphics2D, STROKE_DEFAULT, ALPHA_PRINT, RENDER_PRINT);
        }
        return 0;
    }

    public void exportPNG(File file, int n, int n2) throws IOException {
        PNG pNG = this.getPNGStream(file, n, n2);
        this.exportVector(pNG);
    }

    public void exportEPS(File file) throws IOException {
        Postscript postscript = this.getPostscriptStream(file);
        this.exportVector(postscript);
    }

    public void exportPDF(File file) throws IOException {
        PDF pDF = this.getPDFStream(file);
        this.exportVector(pDF);
    }

    public PNG getPNGStream(File file, int n, int n2) throws IOException {
        double[] dArray = this.getBoundingBox();
        Color color = null;
        if (this.exportColor) {
            color = backgroundColor;
        }
        PNG pNG = new PNG(file, color, n, n2, dArray[0], dArray[1], dArray[2], dArray[3]);
        return pNG;
    }

    public Postscript getPostscriptStream(File file) throws IOException {
        double[] dArray = this.getBoundingBox();
        Color color = null;
        if (this.exportColor) {
            color = backgroundColor;
        }
        Postscript postscript = new Postscript(file, color, dArray[0], dArray[1], dArray[2], dArray[3], "Penrose Empire Rendering", null, null, "penrose tiling empire", "LogN Penrose Empire Software");
        return postscript;
    }

    public PDF getPDFStream(File file) throws IOException {
        double[] dArray = this.getBoundingBox();
        Color color = null;
        if (this.exportColor) {
            color = backgroundColor;
        }
        PDF pDF = new PDF(file, color, dArray[0], dArray[1], dArray[2], dArray[3], "Penrose Empire Rendering", null, null, "penrose tiling empire", "LogN Penrose Empire Software");
        return pDF;
    }

    public double[] getBoundingBox() {
        double[] dArray;
        dArray = new double[]{xOffset - width / 2.0, yOffset - height / 2.0, dArray[0] + width, dArray[1] + height};
        return dArray;
    }

    protected void exportVector(VectorOutput vectorOutput) throws IOException {
        int n;
        AffineTransform[] affineTransformArray;
        Constellation constellation;
        vectorOutput.prepare();
        vectorOutput.setStroke(STROKE_DEFAULT);
        vectorOutput.setStrokeTransparency(1.0);
        vectorOutput.setFillTransparency(0.2);
        if (this.drawKites) {
            constellation = new Kite();
            vectorOutput.createTemplate("kite", constellation.getShape());
            affineTransformArray = new AffineTransform[this.kiteTiles.length];
            n = 0;
            while (n < affineTransformArray.length) {
                affineTransformArray[n] = this.kiteTiles[n].mapping;
                ++n;
            }
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.kitesColor);
                vectorOutput.setFillColor(this.kitesColor);
            }
            if (this.fillTiles) {
                vectorOutput.drawTemplates("kite", affineTransformArray);
            } else {
                vectorOutput.strokeTemplates("kite", affineTransformArray);
            }
        }
        if (this.drawDarts) {
            constellation = new Dart();
            vectorOutput.createTemplate("dart", constellation.getShape());
            affineTransformArray = new AffineTransform[this.dartTiles.length];
            n = 0;
            while (n < affineTransformArray.length) {
                affineTransformArray[n] = this.dartTiles[n].mapping;
                ++n;
            }
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.dartsColor);
                vectorOutput.setFillColor(this.dartsColor);
            }
            if (this.fillTiles) {
                vectorOutput.drawTemplates("dart", affineTransformArray);
            } else {
                vectorOutput.strokeTemplates("dart", affineTransformArray);
            }
        }
        if (this.markCenter) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(Color.black);
                vectorOutput.setFillColor(Color.black);
            }
            if (this.fillTiles) {
                vectorOutput.fillShape(new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            } else {
                vectorOutput.strokeShape(new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            }
        }
        if (this.drawIntersections) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.intersectionsColor);
            }
            vectorOutput.strokeShapes(this.intersections);
        }
        if (this.drawAxes) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.axesColor);
            }
            vectorOutput.strokeShapes(this.axes);
        }
        if (this.drawForced) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.forcedColor);
            }
            vectorOutput.strokeShapes(this.forcedBars);
        }
        if (this.drawUnforced) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.unforcedColor);
            }
            vectorOutput.strokeShapes(this.unforcedBars);
        }
        vectorOutput.finish();
    }

    public void streamEmpire(VectorOutput vectorOutput) throws IOException {
        this.time = System.currentTimeMillis();
        if (!this.searched) {
            System.out.println("Computing center of tiling...");
            this.recomputeArea(-7.0, -7.0, 7.0, 7.0, null);
            this.searched = true;
        }
        double d = xOffset - width / 2.0 - 2.126627021;
        double d2 = yOffset - height / 2.0 - 2.126627021;
        double d3 = d + width + 4.253254042;
        double d4 = d2 + height + 4.253254042;
        vectorOutput.prepare();
        vectorOutput.setStroke(STROKE_DEFAULT);
        vectorOutput.setStrokeTransparency(1.0);
        vectorOutput.setFillTransparency(this.fillTransparency);
        System.out.println("Beginning iteration over the plane");
        int n = (int)Math.ceil((d3 - d) / 96.56);
        int n2 = (int)Math.ceil((d4 - d2) / 96.56);
        this.time = System.currentTimeMillis() - this.time;
        double d5 = d;
        while (d5 < d3) {
            double d6 = d5 + 100.0;
            int n3 = n2;
            double d7 = d2;
            while (d7 < d4) {
                double d8 = d7 + 100.0;
                long l = this.streamArea(d5, d7, d6, d8, vectorOutput);
                this.time += l;
                int n4 = (n - 1) * n2 + --n3;
                int n5 = (int)(l * (long)n4) / 3600000;
                int n6 = (int)(l * (long)n4 / 60000L) - n5 * 60;
                System.out.println(n4 + " blocks remaining " + "(Estimated time remaining: " + n5 + " hours, " + n6 + " minutes)");
                d7 += 96.56;
            }
            --n;
            d5 += 96.56;
        }
        if (this.markCenter) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(Color.black);
                vectorOutput.setFillColor(Color.black);
            }
            if (this.fillTiles) {
                vectorOutput.fillShape(new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            } else {
                vectorOutput.strokeShape(new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
            }
        }
        if (this.drawAxes) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.axesColor);
            }
            vectorOutput.strokeShapes(this.fiveFold.getAxes(d, d2, d3, d4));
        }
        if (this.drawForced) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.forcedColor);
            }
            vectorOutput.strokeShapes(this.fiveFold.getForcedLines(d, d2, d3, d4));
        }
        if (this.drawUnforced) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.unforcedColor);
            }
            vectorOutput.strokeShapes(this.fiveFold.getUnforcedLines(d, d2, d3, d4));
        }
        vectorOutput.finish();
    }

    public long streamArea(double d, double d2, double d3, double d4, VectorOutput vectorOutput) throws IOException {
        Object object;
        Iterator iterator;
        Object object2;
        long l = System.currentTimeMillis();
        boolean bl = true;
        Collection collection = new Vector(0);
        Collection collection2 = new Vector(0);
        Collection collection3 = new Vector(0);
        SortedSet sortedSet = null;
        Vector<IntersectionPoint> vector = null;
        while (bl) {
            bl = false;
            sortedSet = this.fiveFold.findIntersectionPoints(d, d2, d3, d4);
            object2 = sortedSet.iterator();
            vector = new Vector<IntersectionPoint>();
            double d5 = -1.0;
            double d6 = -1.0;
            while (object2.hasNext()) {
                IntersectionPoint intersectionPoint = (IntersectionPoint)object2.next();
                if (intersectionPoint.boxLayer == d5 && intersectionPoint.boxTheta == d6) continue;
                d5 = intersectionPoint.boxLayer;
                d6 = intersectionPoint.boxTheta;
                vector.add(intersectionPoint);
            }
            collection2 = Dart.getConstellations(sortedSet, this.fiveFold, vector, null);
            collection3 = DoubleKite.getConstellations(sortedSet, this.fiveFold, vector, null);
            bl = bl || this.forceNew(collection2);
            boolean bl2 = bl = bl || this.forceNew(collection3);
        }
        collection = Kite.getConstellations(sortedSet, this.fiveFold, vector, null);
        this.numTiles += collection.size() + collection2.size();
        if (this.fillTiles) {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.kitesColor);
                vectorOutput.setFillColor(this.kitesColor);
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = ((Kite)iterator.next()).getShape();
                vectorOutput.drawShape((Shape)object2);
            }
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.dartsColor);
                vectorOutput.setFillColor(this.dartsColor);
            }
            object = collection2.iterator();
            while (object.hasNext()) {
                object2 = ((Dart)object.next()).getShape();
                vectorOutput.drawShape((Shape)object2);
            }
        } else {
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.kitesColor);
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = ((Kite)iterator.next()).getShape();
                vectorOutput.strokeShape((Shape)object2);
            }
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.dartsColor);
            }
            object = collection2.iterator();
            while (object.hasNext()) {
                object2 = ((Dart)object.next()).getShape();
                vectorOutput.strokeShape((Shape)object2);
            }
        }
        if (this.drawIntersections) {
            iterator = sortedSet.iterator();
            if (this.exportColor) {
                vectorOutput.setStrokeColor(this.intersectionsColor);
            }
            while (iterator.hasNext()) {
                object = (IntersectionPoint)iterator.next();
                vectorOutput.strokeShape(((IntersectionPoint)object).getShape());
            }
        }
        return System.currentTimeMillis() - l;
    }

    public void drawAxes(boolean bl) {
        this.drawAxes = bl;
    }

    public void drawForced(boolean bl) {
        this.drawForced = bl;
    }

    public void drawUnforced(boolean bl) {
        this.drawUnforced = bl;
    }

    public void drawIntersections(boolean bl) {
        this.drawIntersections = bl;
    }

    public void drawKites(boolean bl) {
        this.drawKites = bl;
    }

    public void drawDarts(boolean bl) {
        this.drawDarts = bl;
    }

    public void fillTiles(boolean bl) {
        this.fillTiles = bl;
    }

    public void exportColor(boolean bl) {
        this.exportColor = bl;
    }

    public void markCenter(boolean bl) {
        this.markCenter = bl;
    }

    public void tilesNotRhombs(boolean bl) {
        tilesNotRhombs = bl;
    }

    public boolean drawAxes() {
        return this.drawAxes;
    }

    public boolean drawForced() {
        return this.drawForced;
    }

    public boolean drawUnforced() {
        return this.drawUnforced;
    }

    public boolean drawIntersections() {
        return this.drawIntersections;
    }

    public boolean drawKites() {
        return this.drawKites;
    }

    public boolean drawDarts() {
        return this.drawDarts;
    }

    public boolean fillTiles() {
        return this.fillTiles;
    }

    public boolean exportColor() {
        return this.exportColor;
    }

    public boolean markCenter() {
        return this.markCenter;
    }

    public boolean tilesNotRhombs() {
        return tilesNotRhombs;
    }

    public void backgroundColor(Color color) {
        backgroundColor = color;
    }

    public void axesColor(Color color) {
        this.axesColor = color;
    }

    public void forcedColor(Color color) {
        this.forcedColor = color;
    }

    public void unforcedColor(Color color) {
        this.unforcedColor = color;
    }

    public void intersectionsColor(Color color) {
        this.intersectionsColor = color;
    }

    public void kitesColor(Color color) {
        this.kitesColor = color;
    }

    public void dartsColor(Color color) {
        this.dartsColor = color;
    }

    public Color backgroundColor() {
        return backgroundColor;
    }

    public Color axesColor() {
        return this.axesColor;
    }

    public Color forcedColor() {
        return this.forcedColor;
    }

    public Color unforcedColor() {
        return this.unforcedColor;
    }

    public Color intersectionsColor() {
        return this.intersectionsColor;
    }

    public Color kitesColor() {
        return this.kitesColor;
    }

    public Color dartsColor() {
        return this.dartsColor;
    }

    public void setFillTransparency(double d) {
        this.fillTransparency = d;
        this.ALPHA_OVERLAY = AlphaComposite.getInstance(3, (float)d);
    }

    public static boolean inRange(double d) {
        return PenroseTiling.inRange(0.0, d);
    }

    public static boolean inRange(double d, double d2) {
        return PenroseTiling.inRange(d, d2, 1.0E-10);
    }

    public static boolean inRange(double d, double d2, double d3) {
        double d4 = Math.abs(d2 - d);
        return d4 < d3;
    }

    public static double sin(double d) {
        return Math.sin(Math.toRadians(d));
    }

    public static double cos(double d) {
        return Math.cos(Math.toRadians(d));
    }

    public static double tan(double d) {
        return Math.tan(Math.toRadians(d));
    }

    public static double atan2(double d, double d2) {
        return PenroseTiling.toDegrees(Math.atan2(d2, d));
    }

    public static double toDegrees(double d) {
        double d2 = Math.toDegrees(d);
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static double normalizeAngle(double d) {
        double d2 = d;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 >= 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    public void loadProperties(Properties properties) {
        block22: {
            try {
                DEBUG = Integer.parseInt(properties.getProperty("debug", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                double d = Double.parseDouble(properties.getProperty("llx", ""));
                double d2 = Double.parseDouble(properties.getProperty("lly", ""));
                double d3 = Double.parseDouble(properties.getProperty("urx", ""));
                double d4 = Double.parseDouble(properties.getProperty("ury", ""));
                double d5 = d3 - d;
                double d6 = d4 - d2;
                double d7 = d + d5 / 2.0;
                double d8 = d2 + d6 / 2.0;
                this.setDimensions(d5, d6);
                this.setOffset(d7, d8);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG <= 0) break block22;
                System.err.println("Invalid bounding box coordinates provided, using defaults.");
            }
        }
        if (properties.getProperty("drawAxes", "true").equals("false")) {
            this.drawAxes = false;
        }
        if (properties.getProperty("drawForced", "true").equals("false")) {
            this.drawForced = false;
        }
        if (properties.getProperty("drawUnforced", "true").equals("false")) {
            this.drawUnforced = false;
        }
        if (properties.getProperty("drawIntersections", "true").equals("false")) {
            this.drawIntersections = false;
        }
        if (properties.getProperty("drawKites", "true").equals("false")) {
            this.drawKites = false;
        }
        if (properties.getProperty("drawDarts", "true").equals("false")) {
            this.drawDarts = false;
        }
        if (properties.getProperty("markCenter", "true").equals("false")) {
            this.markCenter = false;
        }
        if (properties.getProperty("fillTiles", "true").equals("false")) {
            this.fillTiles = false;
        }
        if (properties.getProperty("exportColor", "true").equals("false")) {
            this.exportColor = false;
        }
        Color color = null;
        color = PenroseTiling.parseColor(properties.getProperty("backgroundColor", ""));
        if (color != null) {
            backgroundColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("axesColor", ""))) != null) {
            this.axesColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("forcedColor", ""))) != null) {
            this.forcedColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("unforcedColor", ""))) != null) {
            this.unforcedColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("intersectionsColor", ""))) != null) {
            this.intersectionsColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("kitesColor", ""))) != null) {
            this.kitesColor = color;
        }
        if ((color = PenroseTiling.parseColor(properties.getProperty("dartsColor", ""))) != null) {
            this.dartsColor = color;
        }
        try {
            double d = Double.parseDouble(properties.getProperty("fillTransparency", ""));
            this.setFillTransparency(d);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static Color parseColor(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[3];
        int n = 0;
        while (n < 3) {
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            ++n;
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public void saveProperties(File file) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("debug", "" + DEBUG + "");
        properties.setProperty("fillTransparency", "" + this.fillTransparency + "");
        double[] dArray = this.getBoundingBox();
        properties.setProperty("llx", "" + dArray[0] + "");
        properties.setProperty("lly", "" + dArray[1] + "");
        properties.setProperty("urx", "" + dArray[2] + "");
        properties.setProperty("ury", "" + dArray[3] + "");
        properties.setProperty("drawAxes", "" + this.drawAxes + "");
        properties.setProperty("drawForced", "" + this.drawForced + "");
        properties.setProperty("drawUnforced", "" + this.drawUnforced + "");
        properties.setProperty("drawIntersections", "" + this.drawIntersections + "");
        properties.setProperty("drawKites", "" + this.drawKites + "");
        properties.setProperty("drawDarts", "" + this.drawDarts + "");
        properties.setProperty("fillTiles", "" + this.fillTiles + "");
        properties.setProperty("markCenter", "" + this.markCenter + "");
        properties.setProperty("exportColor", "" + this.exportColor + "");
        properties.setProperty("backgroundColor", PenroseTiling.printColor(backgroundColor));
        properties.setProperty("axesColor", PenroseTiling.printColor(this.axesColor));
        properties.setProperty("forcedColor", PenroseTiling.printColor(this.forcedColor));
        properties.setProperty("unforcedColor", PenroseTiling.printColor(this.unforcedColor));
        properties.setProperty("intersectionsColor", PenroseTiling.printColor(this.intersectionsColor));
        properties.setProperty("kitesColor", PenroseTiling.printColor(this.kitesColor));
        properties.setProperty("dartsColor", PenroseTiling.printColor(this.dartsColor));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, "Penrose Tiling User Properties");
    }

    protected static String printColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(color.getRed());
        stringBuffer.append(",");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(",");
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 2) {
            Object object;
            Properties properties;
            File file = new File(stringArray[0]);
            File file2 = new File(stringArray[1]);
            PenroseTiling penroseTiling = new PenroseTiling();
            try {
                penroseTiling.loadConfiguration(file);
            }
            catch (IOException iOException) {
                System.err.println("Couldn't parse tiling configuration " + iOException.getMessage());
                System.exit(1);
            }
            if (stringArray.length > 3) {
                properties = new Properties(System.getProperties());
                try {
                    object = new File(stringArray[3]);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    System.err.println("Couldn't read properties file... skipping");
                    properties = System.getProperties();
                }
            } else {
                properties = System.getProperties();
            }
            penroseTiling.loadProperties(properties);
            try {
                object = stringArray[2].equalsIgnoreCase("pdf") ? penroseTiling.getPDFStream(file2) : penroseTiling.getPostscriptStream(file2);
                penroseTiling.streamEmpire((VectorOutput)object);
                System.out.println("Stats:");
                int n = (int)Math.floor(penroseTiling.time / 86400000L);
                int n2 = (int)Math.floor(penroseTiling.time / 3600000L - (long)(n * 24));
                int n3 = (int)Math.floor(penroseTiling.time / 60000L - (long)(n * 24 + n2 * 60));
                int n4 = (int)Math.floor(penroseTiling.time / 1000L - (long)(n * 24 + n2 * 60 + n3 * 60));
                System.out.println("\tTook " + n + " days, " + n2 + " hours, " + n3 + " minutes, " + n4 + " seconds.");
                System.out.println("\tFound " + penroseTiling.numTiles + " tiles");
            }
            catch (IOException iOException) {
                System.err.println("Couldn't Stream Penrose Empire: " + iOException.getMessage());
            }
        } else {
            System.err.println("\nInsufficient number of arguments");
            PenroseTiling.printUsage();
        }
    }

    public static void printUsage() {
        System.err.println("\n\nUsage:\njava PenroseTiling tiling-configuration output-file eps|pdf [properties-file]");
        System.err.println("\nSystem properties may be specified through the Java System Properties\ninterface, or by placing them in the properties file and specifying it on the\ncommand line.");
        System.err.println("\nproperties-file should contain valid system properties, which can be created\nand saved from within the Penrose Applet, or by editing a text file with the\nproperties in them.  Here is a list of user-definable properties:\n\n");
        System.err.println("debug                int: > 0 for debugging output");
        System.err.println("fillTransparency     double: 0 - 1");
        System.err.println("llx                  double: left edge of view");
        System.err.println("lly                  double: lower edge of view");
        System.err.println("urx                  double: right edge of view");
        System.err.println("ury                  double: upper edge of view");
        System.err.println("drawAxes             boolean: draw sequence axes");
        System.err.println("drawForced           boolean: draw forced bars");
        System.err.println("drawUnforced         boolean: draw unforced bars");
        System.err.println("drawIntersections    boolean: draw intersections");
        System.err.println("drawKites            boolean: draw Kite tiles");
        System.err.println("drawDarts            boolean: draw Dart tiles");
        System.err.println("fillTiles            boolean: fill tiles");
        System.err.println("markCenter           boolean: mark center of plane");
        System.err.println("exportColor          boolean: export/print in color");
        System.err.println("backgroundColor      color: background color");
        System.err.println("axesColor            color: axes color");
        System.err.println("forcedColor          color: forced bar color");
        System.err.println("unforcedColor        color: unforced bar color");
        System.err.println("intersectionsColor   color: intersection color");
        System.err.println("kitesColor           color: Kite tile color");
        System.err.println("dartsColor           color: Dart tile color");
        System.err.println("\n(All colors defined as 'rrr,ggg,bbb')\n\n");
        System.exit(1);
    }

    static {
        SHORT = SCALE = MINNICK_A + 0.75;
        LONG = TAU * SCALE;
        width = 14.0;
        height = 14.0;
        xOffset = 0.0;
        yOffset = 0.0;
        DEBUG = 0;
        tilesNotRhombs = true;
        backgroundColor = Color.white;
        STROKE_DEFAULT = new BasicStroke(0.005f, 2, 0, 5.0f);
        ALPHA_SCREEN = AlphaComposite.getInstance(2, 1.0f);
        ALPHA_PRINT = AlphaComposite.getInstance(2, 1.0f);
        ALPHA_DEFAULT = ALPHA_SCREEN;
        RENDER_SCREEN = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RENDER_SCREEN.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        RENDER_SCREEN.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        RENDER_SCREEN.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        RENDER_PRINT = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        RENDER_PRINT.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        RENDER_PRINT.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        RENDER_PRINT.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        RENDER_DEFAULT = RENDER_SCREEN;
    }
}

