/*
 * Decompiled with CFR 0.152.
 */
package net.logn.penrose;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import net.logn.penrose.IntersectionPoint;

public class PointGraph {
    protected Hashtable table = new Hashtable();

    public void add(IntersectionPoint intersectionPoint, IntersectionPoint intersectionPoint2) {
        HashSet<IntersectionPoint> hashSet = (HashSet<IntersectionPoint>)this.table.get(intersectionPoint);
        HashSet hashSet2 = (HashSet)this.table.get(intersectionPoint2);
        if (hashSet2 == null) {
            if (hashSet == null) {
                hashSet = new HashSet<IntersectionPoint>();
                this.table.put(intersectionPoint, hashSet);
            }
            hashSet.add(intersectionPoint2);
        } else if (hashSet == null) {
            hashSet2.add(intersectionPoint);
        } else {
            if (hashSet.contains(intersectionPoint2) || hashSet2.contains(intersectionPoint)) {
                return;
            }
            if (intersectionPoint2.compareTo(intersectionPoint) < 0) {
                hashSet2.add(intersectionPoint);
            } else {
                hashSet.add(intersectionPoint2);
            }
        }
    }

    public void addAll(PointGraph pointGraph) {
        IntersectionPoint[] intersectionPointArray = pointGraph.getPrimaries();
        int n = 0;
        while (n < intersectionPointArray.length) {
            IntersectionPoint[] intersectionPointArray2 = pointGraph.getSecondaries(intersectionPointArray[n]);
            int n2 = 0;
            while (n2 < intersectionPointArray2.length) {
                this.add(intersectionPointArray[n], intersectionPointArray2[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public IntersectionPoint removePrimary(IntersectionPoint intersectionPoint) {
        return (IntersectionPoint)this.table.remove(intersectionPoint);
    }

    public IntersectionPoint removeSecondary(IntersectionPoint intersectionPoint, IntersectionPoint intersectionPoint2) {
        HashSet hashSet = (HashSet)this.table.get(intersectionPoint);
        boolean bl = hashSet.remove(intersectionPoint2);
        if (hashSet.size() == 0) {
            this.table.remove(intersectionPoint);
        }
        if (bl) {
            return intersectionPoint2;
        }
        return null;
    }

    public void removeAll(PointGraph pointGraph) {
        IntersectionPoint[] intersectionPointArray = pointGraph.getPrimaries();
        int n = 0;
        while (n < intersectionPointArray.length) {
            IntersectionPoint[] intersectionPointArray2 = pointGraph.getSecondaries(intersectionPointArray[n]);
            int n2 = 0;
            while (n2 < intersectionPointArray2.length) {
                this.removeSecondary(intersectionPointArray[n], intersectionPointArray2[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public IntersectionPoint[] getPrimaries() {
        IntersectionPoint[] intersectionPointArray = new IntersectionPoint[this.table.size()];
        int n = 0;
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            intersectionPointArray[n] = (IntersectionPoint)enumeration.nextElement();
            ++n;
        }
        return intersectionPointArray;
    }

    public IntersectionPoint[] getSecondaries(IntersectionPoint intersectionPoint) {
        HashSet hashSet = (HashSet)this.table.get(intersectionPoint);
        if (hashSet == null) {
            return new IntersectionPoint[0];
        }
        IntersectionPoint[] intersectionPointArray = new IntersectionPoint[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            intersectionPointArray[n] = (IntersectionPoint)iterator.next();
            ++n;
        }
        return intersectionPointArray;
    }
}

