/*
 * Decompiled with CFR 0.152.
 */
package net.logn.util.vectoroutput;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import net.logn.util.vectoroutput.VectorOutput;

public abstract class AbstractOutput
implements VectorOutput {
    protected FileOutputStream outStream;
    protected Hashtable templates;
    protected double width;
    protected double height;
    protected AffineTransform transform;
    protected double llx;
    protected double lly;
    protected double urx;
    protected double ury;
    protected Color strokeColor = Color.black;
    protected double strokeTransparency = 1.0;
    protected Color fillColor = Color.black;
    protected double fillTransparency = 1.0;
    protected Color backgroundColor = null;
    public static final DecimalFormat truncator = new DecimalFormat("#####.########");

    protected AbstractOutput(File file, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        this(file, null, d, d2, d3, d4, d5, d6);
    }

    protected AbstractOutput(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        this.outStream = new FileOutputStream(file);
        this.width = d;
        this.height = d2;
        this.transform = AbstractOutput.getMap(d3, d4, d5, d6, 0.0, 0.0, this.width, this.height);
        Point2D.Double double_ = new Point2D.Double(d3, d4);
        Point2D.Double double_2 = new Point2D.Double(d5, d6);
        Point2D point2D = this.transform.transform(double_, null);
        Point2D point2D2 = this.transform.transform(double_2, null);
        this.llx = point2D.getX();
        this.lly = point2D.getY();
        this.urx = point2D2.getX();
        this.ury = point2D2.getY();
        if (color != null) {
            this.backgroundColor = color;
        }
        this.templates = new Hashtable();
    }

    public abstract void prepare() throws IOException;

    public abstract void finish() throws IOException;

    public abstract void setStrokeColor(Color var1) throws IOException;

    public abstract void setStroke(Stroke var1) throws IOException;

    public abstract void setStrokeTransparency(double var1) throws IOException;

    public abstract void setFillColor(Color var1) throws IOException;

    public abstract void setFillTransparency(double var1) throws IOException;

    public abstract void strokeShape(Shape var1) throws IOException;

    public void strokeShapes(Shape[] shapeArray) throws IOException {
        int n = 0;
        while (n < shapeArray.length) {
            this.strokeShape(shapeArray[n]);
            ++n;
        }
    }

    public abstract void fillShape(Shape var1) throws IOException;

    public void fillShapes(Shape[] shapeArray) throws IOException {
        int n = 0;
        while (n < shapeArray.length) {
            this.fillShape(shapeArray[n]);
            ++n;
        }
    }

    public void drawShape(Shape shape) throws IOException {
        this.fillShape(shape);
        this.strokeShape(shape);
    }

    public void drawShapes(Shape[] shapeArray) throws IOException {
        int n = 0;
        while (n < shapeArray.length) {
            this.drawShape(shapeArray[n]);
            ++n;
        }
    }

    public void createTemplate(String string, Shape shape) throws IOException {
        GeneralPath generalPath = new GeneralPath(shape);
        this.templates.put(string, generalPath);
    }

    protected Shape getTemplate(String string, AffineTransform affineTransform) {
        GeneralPath generalPath = (GeneralPath)this.templates.get(string);
        if (generalPath != null) {
            GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
            generalPath2.transform(affineTransform);
            return generalPath2;
        }
        return null;
    }

    public void strokeTemplate(String string, AffineTransform affineTransform) throws IOException {
        Shape shape = this.getTemplate(string, affineTransform);
        if (shape != null) {
            this.drawShape(shape);
        }
    }

    public void strokeTemplates(String string, AffineTransform[] affineTransformArray) throws IOException {
        int n = 0;
        while (n < affineTransformArray.length) {
            this.drawTemplate(string, affineTransformArray[n]);
            ++n;
        }
    }

    public void fillTemplate(String string, AffineTransform affineTransform) throws IOException {
        Shape shape = this.getTemplate(string, affineTransform);
        if (shape != null) {
            this.fillShape(shape);
        }
    }

    public void fillTemplates(String string, AffineTransform[] affineTransformArray) throws IOException {
        int n = 0;
        while (n < affineTransformArray.length) {
            this.fillTemplate(string, affineTransformArray[n]);
            ++n;
        }
    }

    public void drawTemplate(String string, AffineTransform affineTransform) throws IOException {
        Shape shape = this.getTemplate(string, affineTransform);
        if (shape != null) {
            this.drawShape(shape);
        }
    }

    public void drawTemplates(String string, AffineTransform[] affineTransformArray) throws IOException {
        int n = 0;
        while (n < affineTransformArray.length) {
            this.drawTemplate(string, affineTransformArray[n]);
            ++n;
        }
    }

    public static AffineTransform getMap(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        AffineTransform affineTransform = new AffineTransform();
        double d9 = (d7 - d5) / (d3 - d);
        double d10 = (d8 - d6) / (d4 - d2);
        double d11 = d9 < d10 ? d9 : d10;
        affineTransform.scale(d11, d11);
        affineTransform.translate(-d, -d2);
        return affineTransform;
    }

    public static String truncate(double d) {
        return truncator.format(d);
    }
}

