/*
 * Decompiled with CFR 0.152.
 */
package net.logn.util.vectoroutput;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.logn.util.vectoroutput.AbstractOutput;

public class PDF
extends AbstractOutput {
    private DataOutputStream printer;
    private Deflater compress;
    private DeflaterOutputStream compressStream;
    private int[] bytesOut;
    private String title;
    private String author;
    private String subject;
    private String keywords;
    private String creator;
    private String F = "f";
    private String S = "S";
    private String FAS = "B";

    public PDF(File file, Color color, double d, double d2, double d3, double d4) throws IOException {
        this(file, color, d, d2, d3, d4, null, null, null, null, null);
    }

    public PDF(File file, Color color, double d, double d2, double d3, double d4, String string, String string2, String string3, String string4, String string5) throws IOException {
        this(file, color, 612.0, 792.0, d, d2, d3, d4, string, string2, string3, string4, string5);
    }

    public PDF(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        this(file, color, d, d2, d3, d4, d5, d6, null, null, null, null, null);
    }

    public PDF(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6, String string, String string2, String string3, String string4, String string5) throws IOException {
        super(file, color, d, d2, d3, d4, d5, d6);
        this.title = string;
        this.author = string2;
        this.subject = string3;
        this.keywords = string4;
        this.creator = string5;
        this.bytesOut = new int[8];
        this.bytesOut[0] = 0;
        this.compress = new Deflater(9);
    }

    public void prepare() throws IOException {
        this.printer = new DataOutputStream(this.outStream);
        this.printer.writeBytes("%PDF-1.3\n");
        this.printer.writeBytes("%");
        this.printer.write(222);
        this.printer.write(173);
        this.printer.write(190);
        this.printer.write(239);
        this.printer.writeBytes("\n");
        this.bytesOut[0] = this.printer.size();
        this.printer.writeBytes("1 0 obj\n");
        this.printer.writeBytes("  <<\n");
        this.printer.writeBytes("     /Type /Catalog\n");
        this.printer.writeBytes("     /Outlines 2 0 R\n");
        this.printer.writeBytes("     /Pages 3 0 R\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[1] = this.printer.size();
        this.printer.writeBytes("2 0 obj\n");
        this.printer.writeBytes("  <<\n");
        this.printer.writeBytes("     /Type /Outlines\n");
        this.printer.writeBytes("     /Count 0\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[2] = this.printer.size();
        this.printer.writeBytes("3 0 obj\n");
        this.printer.writeBytes("  <<\n");
        this.printer.writeBytes("     /Type /Pages\n");
        this.printer.writeBytes("     /Kids [4 0 R]\n");
        this.printer.writeBytes("     /Count 1\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[3] = this.printer.size();
        this.printer.writeBytes("4 0 obj\n");
        this.printer.writeBytes("  <<\n");
        this.printer.writeBytes("     /Type /Page\n");
        this.printer.writeBytes("     /Parent 3 0 R\n");
        this.printer.writeBytes("     /MediaBox [" + (int)Math.floor(this.llx) + " " + (int)Math.floor(this.lly) + " " + (int)Math.ceil(this.urx) + " " + (int)Math.ceil(this.ury) + "]\n");
        this.printer.writeBytes("     /Contents 5 0 R\n");
        this.printer.writeBytes("     /Resources << /ProcSet [/PDF] >>\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[4] = this.printer.size();
        this.printer.writeBytes("5 0 obj\n");
        this.printer.writeBytes("  << /Length 6 0 R /Filter /FlateDecode >>\n");
        this.printer.writeBytes("stream\n");
        this.bytesOut[5] = this.printer.size();
        this.printer.flush();
        this.compressStream = new DeflaterOutputStream((OutputStream)this.outStream, this.compress);
        this.printer = new DataOutputStream(this.compressStream);
        this.printer.writeBytes("q\n");
        if (this.backgroundColor != null) {
            this.setFillColor(this.backgroundColor);
            this.fillShape(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        } else {
            this.backgroundColor = Color.white;
        }
    }

    public void finish() throws IOException {
        this.printer.writeBytes("Q\n");
        this.compressStream.finish();
        int n = this.compress.getTotalOut() + this.bytesOut[5];
        this.printer = new DataOutputStream(this.outStream);
        this.printer.writeBytes("endstream\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[5] = n + this.printer.size();
        this.printer.writeBytes("6 0 obj\n");
        this.printer.writeBytes(this.compress.getTotalOut() + "\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[6] = n + this.printer.size();
        this.printer.writeBytes("7 0 obj\n");
        this.printer.writeBytes("  <<\n");
        if (this.title != null) {
            this.printer.writeBytes("     /Title (" + this.title + ")\n");
        }
        if (this.author != null) {
            this.printer.writeBytes("     /Author (" + this.author + ")\n");
        }
        if (this.subject != null) {
            this.printer.writeBytes("     /Subject (" + this.subject + ")\n");
        }
        if (this.keywords != null) {
            this.printer.writeBytes("     /Keywords (" + this.keywords + ")\n");
        }
        if (this.creator != null) {
            this.printer.writeBytes("     /Creator (" + this.creator + ")\n");
        }
        this.printer.writeBytes("     /Producer (LogN Java Shape to PDF Converter)\n");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = simpleDateFormat.format(new Date());
        this.printer.writeBytes("     /CreationDate (D:" + string + ")\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("endobj\n\n");
        this.bytesOut[7] = n + this.printer.size();
        this.printer.writeBytes("xref\n");
        this.printer.writeBytes("0 " + this.bytesOut.length + "\n");
        this.printer.writeBytes("0000000000 65535 f \n");
        int n2 = 0;
        while (n2 < this.bytesOut.length - 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.bytesOut[n2]);
            int n3 = 0;
            while (n3 < 10 - stringBuffer.length()) {
                this.printer.writeBytes("0");
                ++n3;
            }
            this.printer.writeBytes(stringBuffer.toString() + " 00000 n \n");
            ++n2;
        }
        this.printer.writeBytes("trailer\n");
        this.printer.writeBytes("  <<\n");
        this.printer.writeBytes("    /Size " + this.bytesOut.length + "\n");
        this.printer.writeBytes("    /Root 1 0 R\n");
        this.printer.writeBytes("    /Info 7 0 R\n");
        this.printer.writeBytes("  >>\n");
        this.printer.writeBytes("startxref\n");
        this.printer.writeBytes(this.bytesOut[this.bytesOut.length - 1] + "\n");
        this.printer.writeBytes("%%EOF\n");
    }

    protected void setColor(Color color, double d) throws IOException {
        float[] fArray = color.getRGBColorComponents(null);
        float[] fArray2 = this.backgroundColor.getRGBColorComponents(null);
        double[] dArray = new double[3];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = d * (double)fArray[n] + (1.0 - d) * (double)fArray2[n];
            ++n;
        }
        this.printer.writeBytes(dArray[0] + " " + dArray[1] + " " + dArray[2] + " ");
    }

    public void setStrokeColor(Color color) throws IOException {
        this.strokeColor = color;
        this.setColor(this.strokeColor, this.strokeTransparency);
        this.printer.writeBytes("RG\n");
    }

    public void setFillColor(Color color) throws IOException {
        this.fillColor = color;
        this.setColor(this.fillColor, this.fillTransparency);
        this.printer.writeBytes("rg\n");
    }

    public void setStroke(Stroke stroke) throws IOException {
        BasicStroke basicStroke = (BasicStroke)stroke;
        this.printer.writeBytes(basicStroke.getLineWidth() + " w\n");
        int n = basicStroke.getEndCap();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        this.printer.writeBytes(n2 + " J\n");
        int n3 = basicStroke.getLineJoin();
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 2;
            }
        }
        this.printer.writeBytes(n4 + " j\n");
        this.printer.writeBytes(basicStroke.getMiterLimit() + " M\n");
        float[] fArray = basicStroke.getDashArray();
        if (fArray != null) {
            this.printer.writeBytes("[");
            int n5 = 0;
            while (n5 < fArray.length) {
                this.printer.writeBytes(fArray[n5] + " ");
                ++n5;
            }
            this.printer.writeBytes("] " + basicStroke.getDashPhase() + " d\n");
        } else {
            this.printer.writeBytes("[] 0 d\n");
        }
    }

    public void setStrokeTransparency(double d) throws IOException {
        this.strokeTransparency = d;
        this.setStrokeColor(this.strokeColor);
    }

    public void setFillTransparency(double d) throws IOException {
        this.fillTransparency = d;
        this.setFillColor(this.fillColor);
    }

    protected void outputPath(Shape shape) throws IOException {
        PathIterator pathIterator = shape.getPathIterator(this.transform);
        int n = pathIterator.getWindingRule();
        if (n == 0) {
            this.F = "f*";
            this.FAS = "B*";
        } else {
            this.F = "f";
            this.FAS = "B";
        }
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    this.printer.writeBytes(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " m\n");
                    break;
                }
                case 1: {
                    this.printer.writeBytes(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " l\n");
                    break;
                }
                case 3: {
                    this.printer.writeBytes(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " " + AbstractOutput.truncate(dArray[2]) + " " + AbstractOutput.truncate(dArray[3]) + " " + AbstractOutput.truncate(dArray[4]) + " " + AbstractOutput.truncate(dArray[5]) + " c\n");
                    break;
                }
                case 2: {
                    System.err.println("Quadric Curve " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " NOT IMPLEMENTED");
                    break;
                }
                case 4: {
                    this.printer.writeBytes("h\n");
                }
            }
            pathIterator.next();
        }
    }

    public void strokeShape(Shape shape) throws IOException {
        this.outputPath(shape);
        this.printer.writeBytes(this.S + "\n");
    }

    public void fillShape(Shape shape) throws IOException {
        this.outputPath(shape);
        this.printer.writeBytes(this.F + "\n");
    }

    public void drawShape(Shape shape) throws IOException {
        this.outputPath(shape);
        this.printer.writeBytes(this.FAS + "\n");
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        try {
            PDF pDF = new PDF(file, null, 612.0, 792.0, 100.0, 100.0, 400.0, 400.0, "Test of PDF code", "Jason Healy", "This is a test", "test pdf", "The main() method of the PDF code");
            pDF.prepare();
            pDF.setStroke(new BasicStroke());
            pDF.setStrokeColor(Color.black);
            pDF.strokeShape(new Rectangle2D.Double(110.0, 110.0, 280.0, 280.0));
            pDF.setFillColor(Color.blue);
            pDF.fillShape(new Rectangle2D.Double(150.0, 150.0, 100.0, 200.0));
            pDF.drawShape(new Ellipse2D.Double(120.0, 120.0, 200.0, 100.0));
            pDF.finish();
        }
        catch (IOException iOException) {
            System.err.println("Caught IO Exception" + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

