/*
 * Decompiled with CFR 0.152.
 */
package net.logn.util.vectoroutput;

import com.sun.media.jai.codec.PNGEncodeParam;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.JAI;
import net.logn.util.vectoroutput.AbstractOutput;

public class PNG
extends AbstractOutput {
    private BufferedImage renderedImage;
    private Graphics2D graphics;

    public PNG(File file, Color color, double d, double d2, double d3, double d4) throws IOException {
        super(file, color, d3 - d, d4 - d2, d, d2, d3, d4);
    }

    public PNG(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        super(file, color, d, d2, d3, d6, d5, d4);
    }

    public void prepare() throws IOException {
        this.renderedImage = new BufferedImage((int)Math.ceil(this.width), (int)Math.ceil(this.height), 1);
        this.graphics = this.renderedImage.createGraphics();
        if (this.backgroundColor != null) {
            this.setFillColor(this.backgroundColor);
        } else {
            this.backgroundColor = Color.white;
        }
        this.graphics.setBackground(this.backgroundColor);
        this.graphics.fill(new Rectangle2D.Double(0.0, 0.0, Math.ceil(this.width), Math.ceil(this.height)));
        this.graphics.setColor(this.strokeColor);
        this.transform.translate(-2.0 * (this.transform.getTranslateX() / this.transform.getScaleX()), 0.0);
        this.graphics.setTransform(this.transform);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.graphics.setRenderingHints(renderingHints);
    }

    public void finish() throws IOException {
        JAI.create((String)"encode", (RenderedImage)this.renderedImage, (Object)this.outStream, (Object)"PNG", (Object)PNGEncodeParam.getDefaultEncodeParam((RenderedImage)this.renderedImage));
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    public void setStrokeTransparency(double d) {
        this.strokeTransparency = d;
    }

    public void setFillTransparency(double d) {
        this.fillTransparency = d;
    }

    public void strokeShape(Shape shape) throws IOException {
        this.graphics.setColor(this.strokeColor);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)this.strokeTransparency);
        this.graphics.setComposite(alphaComposite);
        this.graphics.draw(shape);
    }

    public void fillShape(Shape shape) throws IOException {
        this.graphics.setColor(this.fillColor);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)this.fillTransparency);
        this.graphics.setComposite(alphaComposite);
        this.graphics.fill(shape);
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        try {
            PNG pNG = new PNG(file, null, 10.0, 10.0, 100.0, 450.0);
            pNG.prepare();
            pNG.setFillColor(Color.red);
            pNG.fillShape(new Rectangle2D.Double(15.0, 15.0, 20.0, 420.0));
            pNG.setStrokeColor(Color.blue);
            pNG.strokeShape(new Ellipse2D.Double(20.0, 20.0, 10.0, 410.0));
            pNG.drawShape(new Ellipse2D.Double(40.0, 40.0, 40.0, 200.0));
            pNG.finish();
        }
        catch (IOException iOException) {
            System.err.println("Caught IO Exception" + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

