/*
 * Decompiled with CFR 0.152.
 */
package net.logn.util.vectoroutput;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.logn.util.vectoroutput.AbstractOutput;

public class Postscript
extends AbstractOutput {
    private PrintStream printer;
    private String title;
    private String author;
    private String subject;
    private String keywords;
    private String creator;
    private String F = "fill";
    private String S = "stroke";
    private int functionIndex = 1;
    private Color currentColor = null;
    private double currentTransparency = -1.0;

    public Postscript(File file, Color color, double d, double d2, double d3, double d4) throws IOException {
        this(file, color, d, d2, d3, d4, null, null, null, null, null);
    }

    public Postscript(File file, Color color, double d, double d2, double d3, double d4, String string, String string2, String string3, String string4, String string5) throws IOException {
        this(file, color, 612.0, 792.0, d, d2, d3, d4, string, string2, string3, string4, string5);
    }

    public Postscript(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        this(file, color, d, d2, d3, d4, d5, d6, null, null, null, null, null);
    }

    public Postscript(File file, Color color, double d, double d2, double d3, double d4, double d5, double d6, String string, String string2, String string3, String string4, String string5) throws IOException {
        super(file, color, d, d2, d3, d4, d5, d6);
        this.title = string;
        this.author = string2;
        this.subject = string3;
        this.keywords = string4;
        this.creator = string5;
    }

    public void prepare() throws IOException {
        this.printer = new PrintStream(this.outStream);
        this.printer.println("%!PS-Adobe-3.0 EPSF-3.0");
        if (this.title != null) {
            this.printer.println("%%Title (" + this.title + ")");
        }
        if (this.author != null) {
            this.printer.println("%%Author (" + this.author + ")");
        }
        if (this.subject != null) {
            this.printer.println("%%Subject (" + this.subject + ")");
        }
        if (this.keywords != null) {
            this.printer.println("%%Keywords (" + this.keywords + ")");
        }
        if (this.creator != null) {
            this.printer.println("%%Creator (" + this.creator + ")");
        }
        this.printer.println("%%Producer (LogN Java Shape to PDF Converter)");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = simpleDateFormat.format(new Date());
        this.printer.println("%%CreationDate (D:" + string + ")");
        this.printer.println("%%DocumentData: Clean7Bit");
        this.printer.println("%%Origin: 0 0");
        this.printer.println("%%BoundingBox: " + (int)Math.floor(this.llx) + " " + (int)Math.floor(this.lly) + " " + (int)Math.ceil(this.urx) + " " + (int)Math.ceil(this.ury));
        this.printer.println("%%HiresBoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
        this.printer.println("%%ExactBoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
        this.printer.println("%%LanguageLevel: 2");
        this.printer.println("%%Pages: 1");
        this.printer.println("%%Page: 1");
        this.printer.println("%%EndComments\n");
        this.printer.println("\ngsave");
        this.printer.println("newpath");
        this.printer.println(this.llx + " " + this.lly + " moveto");
        this.printer.println(this.urx + " " + this.lly + " lineto");
        this.printer.println(this.urx + " " + this.ury + " lineto");
        this.printer.println(this.llx + " " + this.ury + " lineto");
        this.printer.println("closepath");
        this.printer.println("clip");
        if (this.backgroundColor != null) {
            this.setFillColor(this.backgroundColor);
            this.fillShape(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        } else {
            this.backgroundColor = Color.white;
        }
    }

    public void finish() throws IOException {
        this.printer.println("\ngrestore");
        this.printer.println("\n%%Trailer\n\n%%EOF");
    }

    protected void setColor(Color color, double d) {
        if (color.equals(this.currentColor) && d == this.currentTransparency) {
            return;
        }
        this.currentColor = color;
        this.currentTransparency = d;
        float[] fArray = color.getRGBColorComponents(null);
        float[] fArray2 = this.backgroundColor.getRGBColorComponents(null);
        double[] dArray = new double[3];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = d * (double)fArray[n] + (1.0 - d) * (double)fArray2[n];
            ++n;
        }
        this.printer.println(dArray[0] + " " + dArray[1] + " " + dArray[2] + " setrgbcolor");
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        BasicStroke basicStroke = (BasicStroke)stroke;
        this.printer.println(basicStroke.getLineWidth() + " setlinewidth");
        int n = basicStroke.getEndCap();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        this.printer.println(n2 + " setlinecap");
        int n3 = basicStroke.getLineJoin();
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 2;
            }
        }
        this.printer.println(n4 + " setlinejoin");
        this.printer.println(basicStroke.getMiterLimit() + " setmiterlimit");
        float[] fArray = basicStroke.getDashArray();
        if (fArray != null) {
            this.printer.print("[");
            int n5 = 0;
            while (n5 < fArray.length) {
                this.printer.print(fArray[n5] + " ");
                ++n5;
            }
            this.printer.println("] " + basicStroke.getDashPhase() + " setdash");
        } else {
            this.printer.println("[] 0 setdash");
        }
    }

    public void setStrokeTransparency(double d) {
        this.strokeTransparency = d;
    }

    public void setFillTransparency(double d) {
        this.fillTransparency = d;
    }

    protected void outputPath(Shape shape) throws IOException {
        this.printer.println("newpath");
        PathIterator pathIterator = shape.getPathIterator(this.transform);
        int n = pathIterator.getWindingRule();
        this.F = n == 0 ? "eofill" : "fill";
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    this.printer.println(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " moveto");
                    break;
                }
                case 1: {
                    this.printer.println(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " lineto");
                    break;
                }
                case 3: {
                    this.printer.println(AbstractOutput.truncate(dArray[0]) + " " + AbstractOutput.truncate(dArray[1]) + " " + AbstractOutput.truncate(dArray[2]) + " " + AbstractOutput.truncate(dArray[3]) + " " + AbstractOutput.truncate(dArray[4]) + " " + AbstractOutput.truncate(dArray[5]) + " curveto");
                    break;
                }
                case 2: {
                    System.err.println("Quadric Curve " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " NOT IMPLEMENTED");
                    break;
                }
            }
            pathIterator.next();
        }
        this.printer.println("closepath");
    }

    public void strokeShape(Shape shape) throws IOException {
        this.setColor(this.strokeColor, this.strokeTransparency);
        this.outputPath(shape);
        this.printer.println(this.S);
    }

    public void fillShape(Shape shape) throws IOException {
        this.setColor(this.fillColor, this.fillTransparency);
        this.outputPath(shape);
        this.printer.println(this.F);
    }

    public void drawTemplates(String string, AffineTransform[] affineTransformArray) throws IOException {
        int n = 0;
        while (n < affineTransformArray.length) {
            this.fillTemplate(string, affineTransformArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < affineTransformArray.length) {
            this.strokeTemplate(string, affineTransformArray[n2]);
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        try {
            Postscript postscript = new Postscript(file, null, 612.0, 792.0, 100.0, 100.0, 400.0, 400.0, "Test of PS code", "Jason Healy", "This is a test", "test ps", "The main() method of the PS code");
            postscript.prepare();
            postscript.setStroke(new BasicStroke());
            postscript.setStrokeColor(Color.black);
            postscript.strokeShape(new Rectangle2D.Double(110.0, 110.0, 280.0, 280.0));
            postscript.setFillColor(Color.blue);
            postscript.fillShape(new Rectangle2D.Double(150.0, 150.0, 100.0, 200.0));
            postscript.drawShape(new Ellipse2D.Double(120.0, 120.0, 200.0, 100.0));
            postscript.finish();
        }
        catch (IOException iOException) {
            System.err.println("Caught IO Exception" + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

