// $Header: /opt/cvs/java/net/logn/penrose/ForceBarFrame.java,v 1.4 2001/02/17 20:43:59 jhealy Exp $
// Copyright 2001 Jason Healy.  Please see file COPYRIGHT for details.

package net.logn.penrose;

// AWT Components
import java.awt.Container;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
// AWT Events
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
// Swing Components
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;


/**
 * <p>
 * <b>ForceBarFrame</b> is a frame that presents the user with a GUI that will
 * add forced bars to a set of Musical Sequences.
 * </p>
 *
 * @author Jason Healy
 * @version $Revision: 1.4 $
 *
 * Last Modified $Date: 2001/02/17 20:43:59 $ by $Author: jhealy $
 */
public class ForceBarFrame extends JFrame {

    /** PenroseTiling object to modify */
    protected PenroseTiling pt;

    /** PenrosePanel to preview changes to */
    protected PenrosePanel pp;

    /** Current sequence under consideration */
    protected int sequence;

    /** Current length under consideration */
    protected boolean length = PenroseTiling.LONGER;

    /** Current bar number under consideration */
    protected long barNum = 0;

    /** Text field to input the bar number */
    private JTextField barText;


    /**
     * <p>
     * Constructor.  Gets the component objects from the applet provided.
     * </p>
     *
     * @param penroseApplet The applet to get the tiling and panel from
     */
    public ForceBarFrame(PenroseApplet penroseApplet) {
	
	this(penroseApplet.penroseTiling, penroseApplet.pPanel);

    }


    /**
     * <p>
     * Constructor.  Takes the Five Fold to change and the Panel to preview
     * updates to.
     * </p>
     *
     * @param penroseTiling The PenroseTiling to modify
     * @param penrosePanel The PenrosePanel to preview updates on
     */
    public ForceBarFrame(PenroseTiling penroseTiling, PenrosePanel penrosePanel) {
	
	super("Force New Bars");
	this.setSize(new Dimension(400, 150));

	pt = penroseTiling;
	pp = penrosePanel;


	JLabel seqLabel = new JLabel("Rotation:");

        // Create the radio buttons.
        JRadioButton seq0Button = new JRadioButton("0");
        seq0Button.setMnemonic(KeyEvent.VK_1);
        seq0Button.setActionCommand("0");
        seq0Button.setSelected(true);

        JRadioButton seq1Button = new JRadioButton("72");
        seq1Button.setMnemonic(KeyEvent.VK_2);
        seq1Button.setActionCommand("1");

        JRadioButton seq2Button = new JRadioButton("144");
        seq2Button.setMnemonic(KeyEvent.VK_3);
        seq2Button.setActionCommand("2");

        JRadioButton seq3Button = new JRadioButton("216");
        seq3Button.setMnemonic(KeyEvent.VK_4);
        seq3Button.setActionCommand("3");

        JRadioButton seq4Button = new JRadioButton("288");
        seq4Button.setMnemonic(KeyEvent.VK_5);
        seq4Button.setActionCommand("4");

        // Group the radio buttons.
        ButtonGroup seqGroup = new ButtonGroup();
        seqGroup.add(seq0Button);
        seqGroup.add(seq1Button);
        seqGroup.add(seq2Button);
        seqGroup.add(seq3Button);
        seqGroup.add(seq4Button);

        // Register a listener for the radio buttons.
        SequenceListener seqListener = new SequenceListener();
        seq0Button.addActionListener(seqListener);
        seq1Button.addActionListener(seqListener);
        seq2Button.addActionListener(seqListener);
        seq3Button.addActionListener(seqListener);
        seq4Button.addActionListener(seqListener);

	// Length radio buttons
        JRadioButton longButton = new JRadioButton("Long");
        longButton.setMnemonic(KeyEvent.VK_L);
	longButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    
		    length = PenroseTiling.LONGER;
		}
	    });
        longButton.setSelected(true);

        JRadioButton shortButton = new JRadioButton("Short");
        shortButton.setMnemonic(KeyEvent.VK_S);
	shortButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    
		    length = PenroseTiling.SHORTER;
		}
	    });

        // Group the radio buttons.
        ButtonGroup lengthGroup = new ButtonGroup();
	lengthGroup.add(longButton);
	lengthGroup.add(shortButton);

	// now create the bar input field
	barText = new JTextField(10);
	
	JLabel barLabel = new JLabel("Bar Number:");

	// create the approval buttons
	JButton preview = new JButton("Preview");
        preview.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

		if (ForceBarFrame.this.getBarNum()) {

		    double[] bbox = pt.getBoundingBox();

		    Line2D newBar = pt.fiveFold.sequences[sequence].
			getLine(barNum, bbox[0], bbox[1], bbox[2], bbox[3]);

		    pp.paintShape(newBar, Color.red, false);
		}
            }
        });

	JButton force = new JButton("Force");
        force.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

		if (ForceBarFrame.this.getBarNum()) {
		    
		    pt.fiveFold.sequences[sequence].force(barNum, length);
		    
		    double[] bbox = pt.getBoundingBox();

		    pt.forcedBars = pt.fiveFold.getForcedLines(bbox[0], bbox[1],
							       bbox[2], bbox[3]);
		    pp.redraw();
		}
            }
        });

	JButton done = new JButton("Done");
        done.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

		ForceBarFrame.this.hide();
		ForceBarFrame.this.dispose();
	
            }
        });

	// lay out all the components
	Container contentPane = getContentPane();
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();

	contentPane.setLayout(gridbag);
	c.insets = new Insets(6,6,3,3);

	c.gridx = 0;
	c.gridy = 0;
	gridbag.setConstraints(seqLabel, c);
	contentPane.add(seqLabel);

	c.gridx = 1;
	c.gridy = 0;
	gridbag.setConstraints(seq0Button, c);
	contentPane.add(seq0Button);

	c.gridx = 2;
	c.gridy = 0;
	gridbag.setConstraints(seq1Button, c);
	contentPane.add(seq1Button);

	c.gridx = 3;
	c.gridy = 0;
	gridbag.setConstraints(seq2Button, c);
	contentPane.add(seq2Button);

	c.gridx = 4;
	c.gridy = 0;
	gridbag.setConstraints(seq3Button, c);
	contentPane.add(seq3Button);

	c.gridx = 5;
	c.gridy = 0;
	gridbag.setConstraints(seq4Button, c);
	contentPane.add(seq4Button);

	c.gridx = 0;
	c.gridy = 1;
	gridbag.setConstraints(barLabel, c);
	contentPane.add(barLabel);

	c.gridx = 1;
	c.gridy = 1;
	c.gridwidth = 3;
	gridbag.setConstraints(barText, c);
	contentPane.add(barText);

	c.gridx = 4;
	c.gridy = 1;
	c.gridwidth = 1;
	gridbag.setConstraints(longButton, c);
	contentPane.add(longButton);

	c.gridx = 5;
	c.gridy = 1;
	gridbag.setConstraints(shortButton, c);
	contentPane.add(shortButton);

	c.gridx = 0;
	c.gridy = 2;
	c.gridwidth = 2;
	gridbag.setConstraints(preview, c);
	contentPane.add(preview);

	c.gridx = 2;
	c.gridy = 2;
	gridbag.setConstraints(force, c);
	contentPane.add(force);

	c.gridx = 4;
	c.gridy = 2;
	gridbag.setConstraints(done, c);
	contentPane.add(done);

    }

    /** Listens to the radio buttons. */
    class SequenceListener implements ActionListener { 
        public void actionPerformed(ActionEvent e) {
	    sequence = Integer.parseInt(e.getActionCommand());
        }
    }
    
    
    /**
     * <p>
     * Gets the bar number from the text field.
     * </p>
     *
     * @return boolean True, if the number could be parsed
     */
    protected boolean getBarNum() {
	
	try {
	    barNum = Long.parseLong(barText.getText());
	    return true;
	}
	catch (NumberFormatException nfe) {
	    barNum = 0;
	    barText.setText("");
	    return false;
	}
    }


    /**
     * <p>
     * Starts the frame from a shell prompt.  Simply a wrapper to allow
     * for testing.
     * </p>
     * 
     * @param args Command-line arguments
     */
    public static void main(String args[]) {

        JFrame wrapper = new JFrame("Penrose Applet With Extensions");

        // Add the applet to this shell window
        PenroseApplet applet = new PenroseApplet(new java.util.Properties());
        wrapper.getContentPane().add("Center", applet);

        // Start the applet
        applet.init();
        wrapper.pack();
        wrapper.setSize(new Dimension(600, 600));
        wrapper.show();
	
        ForceBarFrame test = new ForceBarFrame(applet);

	// Add code that quits the applet when the window closes
        test.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {System.exit(0);}
	    });
	
	test.show();
	
    }

    
}

